/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.CauseAnswer;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IncrementValue
extends Value {
    private final int eventID;
    private final int value;

    public IncrementValue(Trace trace, int eventID, int value) {
        super(trace);
        this.eventID = eventID;
        this.value = value;
    }

    @Override
    public int getInteger() {
        return this.value;
    }

    @Override
    public boolean getBoolean() {
        throw new RuntimeException("Can't get boolean from IINC instruction.");
    }

    @Override
    public long getLong() {
        throw new RuntimeException("Can't get boolean from IINC instruction.");
    }

    @Override
    public float getFloat() {
        throw new RuntimeException("Can't get boolean from IINC instruction.");
    }

    @Override
    public double getDouble() {
        throw new RuntimeException("Can't get boolean from IINC instruction.");
    }

    @Override
    public Object getImmutable() {
        throw new RuntimeException("Can't get object from IINC instruction.");
    }

    @Override
    public Integer getValue() {
        return new Integer(this.value);
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public String getVerbalExplanation() {
        String valueText = "<b>" + this.getDisplayName(true) + "</b>";
        return String.valueOf(valueText) + " was incremented to " + this.value;
    }

    @Override
    public String getDisplayName(boolean html) {
        return Integer.toString(this.value);
    }

    @Override
    public boolean hasEventID() {
        return true;
    }

    @Override
    public int getEventID() {
        return this.eventID;
    }

    @Override
    public Answer getAnswer(Question<?> q) {
        return new CauseAnswer(q, this.eventID, "These events were responsible for this increment.");
    }
}

