/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.trace.Trace;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ImmutableKind {
    STRING{

        public Object createObject(Trace trace, DataInputStream data) throws IOException {
            return data.readUTF();
        }

        public void writeObject(Object o, DataOutputStream data) throws IOException {
            data.writeUTF((String)o);
        }
    }
    ,
    COLOR{

        public Object createObject(Trace trace, DataInputStream data) throws IOException {
            return new Color(data.readInt(), true);
        }

        public void writeObject(Object o, DataOutputStream data) throws IOException {
            data.writeInt(((Color)o).getRGB());
        }
    }
    ,
    FONT{

        public Object createObject(Trace trace, DataInputStream data) throws IOException {
            return new Font(data.readUTF(), data.readInt(), data.readInt());
        }

        public void writeObject(Object o, DataOutputStream data) throws IOException {
            Font f = (Font)o;
            data.writeUTF(f.getFamily());
            data.writeInt(f.getStyle());
            data.writeInt(f.getSize());
        }
    }
    ,
    GRADIENT{

        public Object createObject(Trace trace, DataInputStream data) throws IOException {
            return new GradientPaint(data.readFloat(), data.readFloat(), new Color(data.readInt(), true), data.readFloat(), data.readFloat(), new Color(data.readInt(), true), data.readBoolean());
        }

        public void writeObject(Object o, DataOutputStream data) throws IOException {
            GradientPaint p = (GradientPaint)o;
            Point2D p1 = p.getPoint1();
            Point2D p2 = p.getPoint2();
            data.writeFloat((float)p1.getX());
            data.writeFloat((float)p1.getY());
            data.writeInt(p.getColor1().getRGB());
            data.writeFloat((float)p2.getX());
            data.writeFloat((float)p2.getY());
            data.writeInt(p.getColor2().getRGB());
            data.writeBoolean(p.isCyclic());
        }
    }
    ,
    BASICSTROKE{

        public Object createObject(Trace trace, DataInputStream data) throws IOException {
            return new BasicStroke(data.readFloat(), data.readInt(), data.readInt(), data.readFloat());
        }

        public void writeObject(Object o, DataOutputStream data) throws IOException {
            BasicStroke s = (BasicStroke)o;
            data.writeFloat(s.getLineWidth());
            data.writeInt(s.getEndCap());
            data.writeInt(s.getLineJoin());
            data.writeFloat(s.getMiterLimit());
        }
    }
    ,
    RECTANGLE{

        public Object createObject(Trace trace, DataInputStream data) throws IOException {
            return new Rectangle(data.readInt(), data.readInt(), data.readInt(), data.readInt());
        }

        public void writeObject(Object o, DataOutputStream data) throws IOException {
            Rectangle2D r = (Rectangle2D)o;
            data.writeInt((int)r.getX());
            data.writeInt((int)r.getY());
            data.writeInt((int)r.getWidth());
            data.writeInt((int)r.getHeight());
        }
    }
    ,
    TRANSFORM{

        public Object createObject(Trace trace, DataInputStream data) throws IOException {
            return new AffineTransform(data.readFloat(), data.readFloat(), data.readFloat(), data.readFloat(), data.readFloat(), data.readFloat());
        }

        public void writeObject(Object o, DataOutputStream data) throws IOException {
            AffineTransform t = (AffineTransform)o;
            data.writeFloat((float)t.getScaleX());
            data.writeFloat((float)t.getShearY());
            data.writeFloat((float)t.getShearX());
            data.writeFloat((float)t.getScaleY());
            data.writeFloat((float)t.getTranslateX());
            data.writeFloat((float)t.getTranslateY());
        }
    };

    private static ImmutableKind[] values;

    static {
        values = ImmutableKind.values();
    }

    private ImmutableKind() {
    }

    public abstract Object createObject(Trace var1, DataInputStream var2) throws IOException;

    public abstract void writeObject(Object var1, DataOutputStream var2) throws IOException;

    public static ImmutableKind intToType(int event) {
        return values[event];
    }

    public static ImmutableKind classToType(Object o) {
        if (o instanceof String) {
            return STRING;
        }
        if (o instanceof BasicStroke) {
            return BASICSTROKE;
        }
        if (o instanceof GradientPaint) {
            return GRADIENT;
        }
        if (o instanceof Color) {
            return COLOR;
        }
        if (o instanceof Font) {
            return FONT;
        }
        if (o instanceof Rectangle2D) {
            return RECTANGLE;
        }
        if (o instanceof AffineTransform) {
            return TRANSFORM;
        }
        return null;
    }

    /* synthetic */ ImmutableKind(String string, int n, ImmutableKind immutableKind) {
        this();
    }
}

