/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.bytecode.FieldrefContainer;
import edu.cmu.hcii.whyline.trace.NoValueException;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.IntegerVector;
import edu.cmu.hcii.whyline.util.Saveable;
import gnu.trove.TIntLongHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;

public class FieldAssignmentHistory
implements Saveable {
    private final Trace trace;
    private final HashMap<String, IntegerVector> fieldAssignmentsByName = new HashMap(100);
    private final TIntLongHashMap objectIDsByAssignmentID = new TIntLongHashMap(100);

    public FieldAssignmentHistory(Trace trace) {
        this.trace = trace;
    }

    public void addFieldAssignmentID(int eventID) {
        String name = ((FieldrefContainer)((Object)this.trace.getInstruction(eventID))).getFieldref().getName();
        IntegerVector vector = this.fieldAssignmentsByName.get(name);
        if (vector == null) {
            vector = new IntegerVector(10);
            this.fieldAssignmentsByName.put(name, vector);
        }
        vector.append(eventID);
    }

    private long getObjectIDAssigned(int assignmentID) {
        if (this.objectIDsByAssignmentID.containsKey(assignmentID)) {
            return this.objectIDsByAssignmentID.get(assignmentID);
        }
        try {
            long objectID = this.trace.getPutFieldObjectIDAssigned(assignmentID);
            this.objectIDsByAssignmentID.put(assignmentID, objectID);
            return objectID;
        }
        catch (NoValueException e) {
            return 0L;
        }
    }

    public int getDefinitionOfFieldBefore(long objectID, String unqualifiedFieldName, int eventIDBefore) {
        IntegerVector objectFieldAssignments = this.fieldAssignmentsByName.get(unqualifiedFieldName);
        if (objectFieldAssignments == null) {
            return -1;
        }
        int index = objectFieldAssignments.getIndexOfLargestValueLessThanOrEqualTo(eventIDBefore);
        while (index >= 0) {
            int eventID = objectFieldAssignments.get(index);
            if (this.getObjectIDAssigned(eventID) == objectID) {
                return eventID;
            }
            --index;
        }
        return -1;
    }

    public int getDefinitionOfFieldAfter(long objectID, String unqualifiedFieldName, int afterID) {
        IntegerVector assignments = this.fieldAssignmentsByName.get(unqualifiedFieldName);
        if (assignments == null) {
            return -1;
        }
        int index = assignments.getIndexOfLargestValueLessThanOrEqualTo(afterID) + 1;
        while (index < assignments.size()) {
            int eventID = assignments.get(index);
            if (this.getObjectIDAssigned(eventID) == objectID) {
                return eventID;
            }
            ++index;
        }
        return -1;
    }

    public IntegerVector getDefinitionsOfObjectFieldAfter(long objectID, String unqualifiedFieldName, int eventIDAfter) {
        IntegerVector definitions = new IntegerVector(2);
        IntegerVector definitionIDs = this.fieldAssignmentsByName.get(unqualifiedFieldName);
        if (definitionIDs != null) {
            int index = definitionIDs.getIndexOfLargestValueLessThanOrEqualTo(eventIDAfter);
            if (index == -1) {
                index = 0;
            }
            int i = index;
            while (i < definitionIDs.size()) {
                int defID = definitionIDs.get(i);
                if (defID >= eventIDAfter && this.getObjectIDAssigned(defID) == objectID) {
                    definitions.append(defID);
                }
                ++i;
            }
        }
        return definitions;
    }

    public void trimToSize() {
        for (IntegerVector vec : this.fieldAssignmentsByName.values()) {
            vec.trimToSize();
        }
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.fieldAssignmentsByName.size());
        for (String unqualifiedName : this.fieldAssignmentsByName.keySet()) {
            out.writeUTF(unqualifiedName);
            this.fieldAssignmentsByName.get(unqualifiedName).write(out);
        }
    }

    public void read(DataInputStream in) throws IOException {
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            this.fieldAssignmentsByName.put(in.readUTF(), new IntegerVector(in));
            ++i;
        }
    }
}

