/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.bytecode.ClassInfo;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.ExceptionHandler;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.Value;
import edu.cmu.hcii.whyline.util.IntegerVector;
import edu.cmu.hcii.whyline.util.Saveable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ExceptionHistory
implements Saveable {
    private final Trace trace;
    private IntegerVector exceptionIDs = new IntegerVector(100);

    public ExceptionHistory(Trace trace) {
        this.trace = trace;
    }

    public void addExceptionTime(int time) {
        this.exceptionIDs.append(time);
    }

    public IntegerVector getTimes() {
        return this.exceptionIDs;
    }

    public int getExceptionThrownBefore(int eventID) {
        int threadID = this.trace.getThreadID(eventID);
        int index = this.exceptionIDs.getIndexOfLargestValueLessThanOrEqualTo(eventID);
        while (index >= 0) {
            int exceptionEventID = this.exceptionIDs.get(index);
            if (this.trace.getKind(exceptionEventID) == EventKind.EXCEPTION_THROWN && this.trace.getThreadID(exceptionEventID) == threadID) {
                return exceptionEventID;
            }
            --index;
        }
        return -1;
    }

    public int getThrowEventIDForCatchID(int catchID) {
        Instruction catchInstruction = this.trace.getInstruction(catchID);
        ExceptionHandler handler = catchInstruction.getCode().getHandlerStartingWith(catchInstruction);
        assert (handler != null);
        ClassInfo catchType = handler.getCatchType();
        QualifiedClassName catchTypeName = catchType == null ? QualifiedClassName.JAVA_LANG_THROWABLE : catchType.getName();
        int index = this.exceptionIDs.getIndexOfLargestValueLessThanOrEqualTo(catchID);
        while (index >= 0) {
            int exceptionEventID = this.exceptionIDs.get(index);
            if (this.trace.getKind(exceptionEventID) == EventKind.EXCEPTION_THROWN && this.trace.getThreadID(exceptionEventID) == this.trace.getThreadID(catchID)) {
                Value exceptionValue = this.trace.getOperandStackValue(exceptionEventID, 0);
                int exceptionValueID = exceptionValue.getEventID();
                if (this.trace.getKind((int)exceptionValueID).isValueProduced) {
                    if (catchTypeName == QualifiedClassName.JAVA_LANG_THROWABLE) {
                        return exceptionEventID;
                    }
                    if (catchTypeName == QualifiedClassName.JAVA_LANG_EXCEPTION) {
                        return exceptionEventID;
                    }
                    long id = this.trace.getObjectIDProduced(exceptionValueID);
                    if (id < 0L) {
                        QualifiedClassName typeOfException = this.trace.getClassnameOfObjectID(id);
                        Classfile exceptionClass = this.trace.getClassfileByName(typeOfException);
                        if (typeOfException == catchTypeName || exceptionClass != null && exceptionClass.isSubclassOf(catchTypeName)) {
                            return exceptionEventID;
                        }
                    }
                }
            }
            --index;
        }
        return -1;
    }

    public IntegerVector getExceptionsCaughtBetween(int startID, int endID, int threadID) {
        IntegerVector catches = new IntegerVector(10);
        int index = this.exceptionIDs.getIndexOfLargestValueLessThanOrEqualTo(endID);
        while (index >= 0) {
            int exceptionEventID = this.exceptionIDs.get(index);
            if (exceptionEventID <= startID) {
                return catches;
            }
            if (this.trace.getKind(exceptionEventID) == EventKind.EXCEPTION_CAUGHT && this.trace.getThreadID(exceptionEventID) == threadID) {
                catches.append(exceptionEventID);
            }
            --index;
        }
        return catches;
    }

    public void write(DataOutputStream out) throws IOException {
        this.exceptionIDs.write(out);
    }

    public void read(DataInputStream in) throws IOException {
        this.exceptionIDs.read(in);
    }
}

