/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.Whyline;
import edu.cmu.hcii.whyline.bytecode.ARRAYLENGTH;
import edu.cmu.hcii.whyline.bytecode.AbstractReturn;
import edu.cmu.hcii.whyline.bytecode.BinaryComputation;
import edu.cmu.hcii.whyline.bytecode.CHECKCAST;
import edu.cmu.hcii.whyline.bytecode.ClassInfo;
import edu.cmu.hcii.whyline.bytecode.DUP;
import edu.cmu.hcii.whyline.bytecode.DUP2;
import edu.cmu.hcii.whyline.bytecode.DUP2_X1;
import edu.cmu.hcii.whyline.bytecode.DUP2_X2;
import edu.cmu.hcii.whyline.bytecode.DUP_X1;
import edu.cmu.hcii.whyline.bytecode.DUP_X2;
import edu.cmu.hcii.whyline.bytecode.Duplication;
import edu.cmu.hcii.whyline.bytecode.ExceptionHandler;
import edu.cmu.hcii.whyline.bytecode.GETFIELD;
import edu.cmu.hcii.whyline.bytecode.GETSTATIC;
import edu.cmu.hcii.whyline.bytecode.GetArrayValue;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.IFEQ;
import edu.cmu.hcii.whyline.bytecode.IFGE;
import edu.cmu.hcii.whyline.bytecode.IFGT;
import edu.cmu.hcii.whyline.bytecode.IFLE;
import edu.cmu.hcii.whyline.bytecode.IFLT;
import edu.cmu.hcii.whyline.bytecode.IFNE;
import edu.cmu.hcii.whyline.bytecode.IF_ICMPEQ;
import edu.cmu.hcii.whyline.bytecode.IF_ICMPGE;
import edu.cmu.hcii.whyline.bytecode.IF_ICMPGT;
import edu.cmu.hcii.whyline.bytecode.IF_ICMPLE;
import edu.cmu.hcii.whyline.bytecode.IF_ICMPLT;
import edu.cmu.hcii.whyline.bytecode.IF_ICMPNE;
import edu.cmu.hcii.whyline.bytecode.IINC;
import edu.cmu.hcii.whyline.bytecode.INSTANCEOF;
import edu.cmu.hcii.whyline.bytecode.INVOKESTATIC;
import edu.cmu.hcii.whyline.bytecode.Instantiation;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MONITORENTER;
import edu.cmu.hcii.whyline.bytecode.NEW;
import edu.cmu.hcii.whyline.bytecode.PUTFIELD;
import edu.cmu.hcii.whyline.bytecode.PUTSTATIC;
import edu.cmu.hcii.whyline.bytecode.PushConstant;
import edu.cmu.hcii.whyline.bytecode.RETURN;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import edu.cmu.hcii.whyline.bytecode.UnaryComputation;
import edu.cmu.hcii.whyline.trace.KeyArguments;
import edu.cmu.hcii.whyline.trace.MouseArguments;
import edu.cmu.hcii.whyline.trace.NoValueException;
import edu.cmu.hcii.whyline.trace.OperandStackType;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.Value;
import java.awt.event.KeyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EventKind
extends Enum<EventKind> {
    public static final /* enum */ EventKind PUTFIELD = new EventKind("(J)V", null, false, false, false, false, false, false, true, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            return String.valueOf(((PUTFIELD)trace.getInstruction(eventID)).getLocalIDName()) + " = " + trace.getOperandStackValue(eventID, 1).getDisplayName(false);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return 1.getAssignmentHTML(((PUTFIELD)trace.getInstruction(eventID)).getLocalIDName(), trace.getOperandStackValue(eventID, 1).getDisplayName(true));
        }
    };
    public static final /* enum */ EventKind PUTSTATIC = new EventKind("(J)V", null, false, false, false, false, false, false, true, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            return String.valueOf(((PUTSTATIC)trace.getInstruction(eventID)).getLocalIDName()) + " = " + trace.getOperandStackValue(eventID, 0).getDisplayName(false);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            PUTSTATIC put = (PUTSTATIC)trace.getInstruction(eventID);
            return 2.getAssignmentHTML(String.valueOf(put.getFieldref().getClassname().getSimpleName()) + "." + put.getLocalIDName(), trace.getOperandStackValue(eventID, 0).getDisplayName(true));
        }
    };
    public static final /* enum */ EventKind SETARRAY = new EventKind("(J)V", null, false, false, false, false, false, false, true, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            long arrayID = trace.getOperandStackValue(eventID, 0).getLong();
            if (arrayID < 0L) {
                return "[unknown array at unknown index] =?";
            }
            return String.valueOf(trace.getDescriptionOfObjectID(arrayID)) + "[" + trace.getOperandStackValue(eventID, 1).getDisplayName(false) + "] = " + trace.getOperandStackValue(eventID, 2).getDisplayName(false);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            long arrayID = trace.getOperandStackValue(eventID, 0).getLong();
            String array = arrayID < 0L ? "(unknown array)" : trace.getDescriptionOfObjectID(arrayID);
            String index = trace.getOperandStackValue(eventID, 1).getDisplayName(true);
            String value = trace.getOperandStackValue(eventID, 2).getDisplayName(true);
            return 3.getAssignmentHTML(String.valueOf(array) + "[" + index + "]", value);
        }
    };
    public static final /* enum */ EventKind SETLOCAL = new EventKind("(J)V", null, false, false, false, false, false, false, true, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            Value value = trace.getOperandStackValue(eventID, 0);
            String argumentString = value == null ? "?" : value.getDisplayName(false);
            return String.valueOf(((SetLocal)trace.getInstruction(eventID)).getLocalIDName()) + " = " + argumentString;
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            Value valueSet = trace.getOperandStackValue(eventID, 0);
            String value = valueSet == null ? "<b>(unknown value)</b>" : valueSet.getDisplayName(true);
            return 4.getAssignmentHTML(((SetLocal)trace.getInstruction(eventID)).getLocalIDName(), value);
        }
    };
    public static final /* enum */ EventKind IINC = new EventKind("(IJ)V", null, false, false, false, false, false, false, true, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            IINC set = (IINC)trace.getInstruction(eventID);
            try {
                int val = trace.getIncrementValue(eventID);
                return String.valueOf(set.getLocalIDName()) + " = " + val;
            }
            catch (NoValueException e) {
                return String.valueOf(set.getLocalIDName()) + " = unknown";
            }
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            IINC set = (IINC)trace.getInstruction(eventID);
            return "<b>" + set.getLocalIDName() + "</b> was incremented by <b>" + set.getIncrement() + "</b>";
        }
    };
    public static final /* enum */ EventKind COMPINTS = new EventKind("(J)V", null, false, false, false, false, false, true, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            try {
                int one = trace.getOperandStackValue(eventID, 0).getInteger();
                int two = trace.getOperandStackValue(eventID, 1).getInteger();
                Instruction inst = trace.getInstruction(eventID);
                if (inst instanceof IF_ICMPEQ) {
                    return one == two ? one + " == " + two : one + " != " + two;
                }
                if (inst instanceof IF_ICMPGE) {
                    return one >= two ? one + " >= " + two : one + " < " + two;
                }
                if (inst instanceof IF_ICMPGT) {
                    return one > two ? one + " > " + two : one + " <= " + two;
                }
                if (inst instanceof IF_ICMPLE) {
                    return one <= two ? one + " <= " + two : one + " > " + two;
                }
                if (inst instanceof IF_ICMPNE) {
                    return one != two ? one + " != " + two : one + " == " + two;
                }
                if (inst instanceof IF_ICMPLT) {
                    return one < two ? one + " < " + two : one + " >= " + two;
                }
                return "";
            }
            catch (NoValueException e) {
                return "I wasn't able to record the values used for this comparison.";
            }
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            Value one = trace.getOperandStackValue(eventID, 0);
            Value two = trace.getOperandStackValue(eventID, 1);
            return "Compared <b>" + one.getDisplayName(true) + "</b> and <b>" + two.getDisplayName(true) + "</b>";
        }
    };
    public static final /* enum */ EventKind COMPZERO = new EventKind("(J)V", null, false, false, false, false, false, true, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            try {
                int val = trace.getOperandStackValue(eventID, 0).getInteger();
                Instruction inst = trace.getInstruction(eventID);
                if (inst instanceof IFEQ) {
                    return val == 0 ? val + " == 0" : val + " != 0";
                }
                if (inst instanceof IFGE) {
                    return val >= 0 ? val + " >= 0" : val + " < 0";
                }
                if (inst instanceof IFGT) {
                    return val > 0 ? val + " > 0" : val + " <= 0";
                }
                if (inst instanceof IFLE) {
                    return val <= 0 ? val + " <= 0" : val + " > 0";
                }
                if (inst instanceof IFNE) {
                    return val != 0 ? val + " != 0" : val + " == 0";
                }
                if (inst instanceof IFLT) {
                    return val < 0 ? val + " < 0" : " >= 0";
                }
                return "";
            }
            catch (NoValueException e) {
                return "I wasn't able to record the values used for this comparison.";
            }
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            Value val = trace.getOperandStackValue(eventID, 0);
            return "Compared <b>" + val.getDisplayName(true) + "</b> to <b>0</b>";
        }
    };
    public static final /* enum */ EventKind COMPREFS = new EventKind("(J)V", null, false, false, false, false, false, true, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            long one = trace.getOperandStackValue(eventID, 0).getLong();
            long two = trace.getOperandStackValue(eventID, 1).getLong();
            if (one < 0L || two < 0L) {
                return "I wasn't able to record the values used for this comparison.";
            }
            if (one == two) {
                return "=";
            }
            return "!=";
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            long one = trace.getOperandStackValue(eventID, 0).getLong();
            long two = trace.getOperandStackValue(eventID, 1).getLong();
            return "Compared <b>" + trace.getDescriptionOfObjectID(one) + "</b> to <b>" + trace.getDescriptionOfObjectID(two);
        }
    };
    public static final /* enum */ EventKind COMPNULL = new EventKind("(J)V", null, false, false, false, false, false, true, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            long id = trace.getOperandStackValue(eventID, 0).getLong();
            if (id == 0L) {
                return "= null";
            }
            if (id < 0L) {
                return "I wasn't able to record the values used for this comparison.";
            }
            return "!= null";
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            Value value = trace.getOperandStackValue(eventID, 0);
            long id = value.getLong();
            return "Compared <b>" + trace.getDescriptionOfObjectID(id) + "</b> to <b>null</b>";
        }
    };
    public static final /* enum */ EventKind TABLEBRANCH = new EventKind("(J)V", null, false, false, false, false, false, true, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            return "case " + trace.getOperandStackValue(eventID, 0).getDisplayName(false);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return "Switched on <b>" + trace.getOperandStackValue(eventID, 0).getDisplayName(true) + "</b>";
        }
    };
    public static final /* enum */ EventKind INVOKE_VIRTUAL = new EventKind("(J)V", null, false, false, false, true, false, false, false, false, true, false){

        public String getHTMLDescription(Trace trace, int eventID) {
            return 11.getInvocationHTML(trace, eventID);
        }

        public String getDescription(Trace trace, int eventID) {
            return 11.getInvocationHTML(trace, eventID);
        }
    };
    public static final /* enum */ EventKind INVOKE_SPECIAL = new EventKind("(J)V", null, false, false, false, true, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            return 12.getInvocationHTML(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return 12.getInvocationHTML(trace, eventID);
        }
    };
    public static final /* enum */ EventKind INVOKE_STATIC = new EventKind("(J)V", null, false, false, false, true, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            return 13.getInvocationHTML(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return 13.getInvocationHTML(trace, eventID);
        }
    };
    public static final /* enum */ EventKind INVOKE_INTERFACE = new EventKind("(J)V", null, false, false, false, true, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            return 14.getInvocationHTML(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return 14.getInvocationHTML(trace, eventID);
        }
    };
    public static final /* enum */ EventKind START_METHOD = new EventKind("(J)V", null, false, false, false, false, false, false, false, false, true, true){

        public String getDescription(Trace trace, int eventID) {
            return String.valueOf(trace.getInstruction(eventID).getMethod().getInternalName()) + "()";
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            Instruction inst = trace.getInstruction(eventID);
            return "<b>" + inst.getMethod().getJavaName() + "</b> began.";
        }
    };
    public static final /* enum */ EventKind RETURN = new EventKind("(J)V", null, false, false, false, false, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            if (trace.getInstruction(eventID) instanceof RETURN) {
                return "return";
            }
            return "return " + trace.getOperandStackValue(eventID, 0).getDisplayName(false);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            AbstractReturn ret = (AbstractReturn)trace.getInstruction(eventID);
            String prefix = "<b>" + ret.getMethod().getJavaName() + "()</b> returned";
            if (ret instanceof RETURN) {
                return prefix;
            }
            return String.valueOf(prefix) + " <b>" + trace.getOperandStackValue(eventID, 0).getDisplayName(true) + "</b>";
        }
    };
    public static final /* enum */ EventKind EXCEPTION_THROWN = new EventKind("(J)V", null, false, false, false, false, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            try {
                Value exThrown = trace.getOperandStackValue(eventID, 0);
                return exThrown == null ? "unknown exception" : "" + exThrown.getImmutable();
            }
            catch (NoValueException e) {
                return "An exception was thrown, but I was unable to determine the type.";
            }
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            Value exThrown = trace.getOperandStackValue(eventID, 0);
            long exID = exThrown.getLong();
            if (exID < 0L) {
                return "An exception was thrown, but I was unable to determine the type.";
            }
            return "A <b>" + (exThrown == null ? "unknown type of exception" : trace.getClassnameOfObjectID(exID)) + "</b> was thrown.";
        }
    };
    public static final /* enum */ EventKind EXCEPTION_CAUGHT = new EventKind("(J)V", null, false, false, false, false, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            Instruction inst = trace.getInstruction(eventID);
            return "exception caught in " + inst.getMethod().getJavaName() + "()";
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            String kind = "Exception";
            Instruction inst = trace.getInstruction(eventID);
            for (ExceptionHandler handler : inst.getCode().getExceptionTable()) {
                if (handler.getHandlerPC() != inst) continue;
                ClassInfo exceptionType = handler.getCatchType();
                if (exceptionType == null) {
                    kind = "Exception";
                    break;
                }
                kind = exceptionType.getSimpleName();
                break;
            }
            return "<b>" + kind + "</b> caught in <b>" + inst.getMethod().getJavaName() + "()</b>";
        }
    };
    public static final /* enum */ EventKind MONITOR = new EventKind("(J)V", null, false, false, false, false, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            Instruction inst = trace.getInstruction(eventID);
            Value value = trace.getOperandStackValue(eventID, 0);
            return String.valueOf(value.getDisplayName(true)) + (inst instanceof MONITORENTER ? " acquired lock" : " released lock");
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            Instruction inst = trace.getInstruction(eventID);
            Value value = trace.getOperandStackValue(eventID, 0);
            return "<b>" + value.getDisplayName(true) + "</b> " + (inst instanceof MONITORENTER ? " acquired lock" : " released lock");
        }
    };
    public static final /* enum */ EventKind CONSTANT_INTEGER_PRODUCED = new EventKind("(J)V", OperandStackType.INT, true, true, false, false, false, false, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfConstantProduced(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind CONSTANT_SHORT_PRODUCED = new EventKind("(J)V", OperandStackType.INT, true, true, false, false, false, false, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfConstantProduced(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind CONSTANT_BYTE_PRODUCED = new EventKind("(J)V", OperandStackType.INT, true, true, false, false, false, false, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfConstantProduced(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind CONSTANT_FLOAT_PRODUCED = new EventKind("(J)V", OperandStackType.FLOAT, true, true, false, false, false, false, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfConstantProduced(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind CONSTANT_BOOLEAN_PRODUCED = new EventKind("(J)V", OperandStackType.INT, true, true, false, false, false, false, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfConstantProduced(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind CONSTANT_CHARACTER_PRODUCED = new EventKind("(J)V", OperandStackType.INT, true, true, false, false, false, false, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfConstantProduced(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind CONSTANT_DOUBLE_PRODUCED = new EventKind("(J)V", OperandStackType.DOUBLE, true, true, false, false, false, false, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfConstantProduced(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind CONSTANT_LONG_PRODUCED = new EventKind("(J)V", OperandStackType.LONG, true, true, false, false, false, false, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfConstantProduced(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind CONSTANT_OBJECT_PRODUCED = new EventKind("(J)V", OperandStackType.REFERENCE, true, true, true, false, false, false, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfConstantProduced(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind THIS_PRODUCED = new EventKind("(J)V", OperandStackType.REFERENCE, false, true, true, false, false, false, false, false, false, false){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfObjectProduced(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind INTEGER_PRODUCED = new EventKind("(IJ)V", OperandStackType.INT, false, true, false, false, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            try {
                return Integer.toString(trace.getIntegerProduced(eventID));
            }
            catch (NoValueException e) {
                return "?";
            }
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind SHORT_PRODUCED = new EventKind("(SJ)V", OperandStackType.INT, false, true, false, false, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            try {
                return Short.toString(trace.getShortProduced(eventID));
            }
            catch (NoValueException e) {
                return "?";
            }
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind BYTE_PRODUCED = new EventKind("(BJ)V", OperandStackType.INT, false, true, false, false, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            try {
                return Byte.toString(trace.getByteProduced(eventID));
            }
            catch (NoValueException e) {
                return "?";
            }
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind FLOAT_PRODUCED = new EventKind("(FJ)V", OperandStackType.FLOAT, false, true, false, false, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            try {
                return Float.toString(trace.getFloatProduced(eventID));
            }
            catch (NoValueException e) {
                return "?";
            }
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind BOOLEAN_PRODUCED = new EventKind("(ZJ)V", OperandStackType.INT, false, true, false, false, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            try {
                return Boolean.toString(trace.getBooleanProduced(eventID));
            }
            catch (NoValueException e) {
                return "?";
            }
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind CHARACTER_PRODUCED = new EventKind("(CJ)V", OperandStackType.INT, false, true, false, false, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            try {
                return Character.toString(trace.getCharacterProduced(eventID));
            }
            catch (NoValueException e) {
                return "?";
            }
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind DOUBLE_PRODUCED = new EventKind("(DJ)V", OperandStackType.DOUBLE, false, true, false, false, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            try {
                return Double.toString(trace.getDoubleProduced(eventID));
            }
            catch (NoValueException e) {
                return "?";
            }
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind LONG_PRODUCED = new EventKind("(JJ)V", OperandStackType.LONG, false, true, false, false, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            return Long.toString(trace.getLongProduced(eventID));
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind OBJECT_PRODUCED = new EventKind("(Ljava/lang/Object;ZJ)V", OperandStackType.REFERENCE, false, true, true, false, false, false, false, false, true, false){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfObjectProduced(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind NEW_OBJECT = new EventKind("(Ljava/lang/Object;ZJ)V", OperandStackType.REFERENCE, false, true, true, false, false, false, false, true, true, false){

        public String getDescription(Trace trace, int eventID) {
            long id = trace.getObjectIDProduced(eventID);
            return "new " + (id < 0L ? "?" : trace.getDescriptionOfObjectID(id));
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind NEW_ARRAY = new EventKind("(Ljava/lang/Object;J)V", OperandStackType.REFERENCE, false, true, true, false, false, false, false, true, true, false){

        public String getDescription(Trace trace, int eventID) {
            long id = trace.getObjectIDProduced(eventID);
            return "new " + (id < 0L ? "[?]" : trace.getDescriptionOfObjectID(id));
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfValueProduced(trace, eventID);
        }
    };
    public static final /* enum */ EventKind INTEGER_ARG = new EventKind("(IJ)V", OperandStackType.INT, false, false, false, false, true, false, true, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfSetArgumentEvent(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfSetMethodArgument(trace, eventID);
        }
    };
    public static final /* enum */ EventKind SHORT_ARG = new EventKind("(SJ)V", OperandStackType.INT, false, false, false, false, true, false, true, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfSetArgumentEvent(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfSetMethodArgument(trace, eventID);
        }
    };
    public static final /* enum */ EventKind BYTE_ARG = new EventKind("(BJ)V", OperandStackType.INT, false, false, false, false, true, false, true, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfSetArgumentEvent(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfSetMethodArgument(trace, eventID);
        }
    };
    public static final /* enum */ EventKind FLOAT_ARG = new EventKind("(FJ)V", OperandStackType.FLOAT, false, false, false, false, true, false, true, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfSetArgumentEvent(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfSetMethodArgument(trace, eventID);
        }
    };
    public static final /* enum */ EventKind BOOLEAN_ARG = new EventKind("(ZJ)V", OperandStackType.INT, false, false, false, false, true, false, true, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfSetArgumentEvent(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfSetMethodArgument(trace, eventID);
        }
    };
    public static final /* enum */ EventKind CHARACTER_ARG = new EventKind("(CJ)V", OperandStackType.INT, false, false, false, false, true, false, true, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfSetArgumentEvent(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfSetMethodArgument(trace, eventID);
        }
    };
    public static final /* enum */ EventKind DOUBLE_ARG = new EventKind("(DJ)V", OperandStackType.DOUBLE, false, false, false, false, true, false, true, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfSetArgumentEvent(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfSetMethodArgument(trace, eventID);
        }
    };
    public static final /* enum */ EventKind LONG_ARG = new EventKind("(JJ)V", OperandStackType.LONG, false, false, false, false, true, false, true, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfSetArgumentEvent(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfSetMethodArgument(trace, eventID);
        }
    };
    public static final /* enum */ EventKind OBJECT_ARG = new EventKind("(Ljava/lang/Object;J)V", OperandStackType.REFERENCE, false, false, false, false, true, false, true, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            return this.getDescriptionOfSetArgumentEvent(trace, eventID);
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getExplanationOfSetMethodArgument(trace, eventID);
        }
    };
    public static final /* enum */ EventKind GETGRAPHICS = new EventKind("(Ljava/lang/Object;J)Ljava/awt/Graphics2D;", null, false, false, false, false, false, false, false, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            return "repaint";
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return "repaint";
        }
    };
    public static final /* enum */ EventKind CREATEGRAPHICS = new EventKind("(Ljava/lang/Object;J)Ljava/awt/Graphics2D;", null, false, false, false, false, false, false, false, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            return "create graphics context";
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return "create graphics context";
        }
    };
    public static final /* enum */ EventKind MOUSE_EVENT = new EventKind("(Ljava/lang/Object;IIIIJ)V", null, false, false, false, false, false, false, false, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            String description = null;
            MouseArguments args = trace.getMouseArguments(eventID);
            int type = args.type;
            int button = args.button;
            description = type == 500 ? "button " + button + " click" : (type == 506 ? "mouse drag" : (type == 501 ? "button " + button + " press" : (type == 502 ? "button " + button + " release" : (type == 503 || type == 504 || type == 505 ? "mouse move" : (type == 507 ? "mouse wheel move" : "unknown type of mouse event")))));
            return description;
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getDescription(trace, eventID);
        }
    };
    public static final /* enum */ EventKind KEY_EVENT = new EventKind("(Ljava/lang/Object;IIICIJ)V", null, false, false, false, false, false, false, false, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            KeyArguments args = trace.getKeyArguments(eventID);
            int type = args.type;
            StringBuilder builder = new StringBuilder();
            String modifiersText = KeyEvent.getModifiersExText(args.modifiers);
            builder.append(modifiersText);
            if (modifiersText.length() > 0) {
                builder.append(" ");
            }
            if (type == 401) {
                builder.append(KeyEvent.getKeyText(args.keyCode));
                builder.append(" was pressed");
            } else if (type == 402) {
                builder.append(KeyEvent.getKeyText(args.keyCode));
                builder.append(" was released");
            } else if (type == 400) {
                builder.append('\'');
                builder.append((char)args.keyChar);
                builder.append('\'');
                builder.append(" was typed");
            } else {
                builder.append("unknown type of mouse event ");
            }
            return builder.toString();
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getDescription(trace, eventID);
        }
    };
    public static final /* enum */ EventKind WINDOW = new EventKind("(Ljava/lang/Object;J)V", null, false, false, false, false, false, false, false, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            return "window was " + (this.isHide(trace, eventID) ? "hidden" : "shown");
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getDescription(trace, eventID);
        }

        public boolean isHide(Trace trace, int eventID) {
            return trace.getInstruction(eventID).getMethod().getInternalName().equals("hide");
        }
    };
    public static final /* enum */ EventKind IMAGE_SIZE = new EventKind("(Ljava/lang/Object;J)V", null, false, false, false, false, false, false, false, false, false, true){

        public String getDescription(Trace trace, int eventID) {
            return "image size";
        }

        public String getHTMLDescription(Trace trace, int eventID) {
            return this.getDescription(trace, eventID);
        }
    };
    public final String name;
    public final String descriptor;
    public final int id = this.ordinal();
    public final boolean isConstantProduced;
    private final OperandStackType stackType;
    public final boolean isValueProduced;
    public final boolean isObjectProduced;
    public final boolean isInvocation;
    public final boolean isArgument;
    public final boolean isBranch;
    public final boolean isDefinition;
    public final boolean isInstantiation;
    public final boolean isNonArgumentDefinition;
    public final boolean loadImmediately;
    public final boolean isArtificial;
    private static EventKind[] values;
    private static final /* synthetic */ EventKind[] ENUM$VALUES;

    static {
        ENUM$VALUES = new EventKind[]{PUTFIELD, PUTSTATIC, SETARRAY, SETLOCAL, IINC, COMPINTS, COMPZERO, COMPREFS, COMPNULL, TABLEBRANCH, INVOKE_VIRTUAL, INVOKE_SPECIAL, INVOKE_STATIC, INVOKE_INTERFACE, START_METHOD, RETURN, EXCEPTION_THROWN, EXCEPTION_CAUGHT, MONITOR, CONSTANT_INTEGER_PRODUCED, CONSTANT_SHORT_PRODUCED, CONSTANT_BYTE_PRODUCED, CONSTANT_FLOAT_PRODUCED, CONSTANT_BOOLEAN_PRODUCED, CONSTANT_CHARACTER_PRODUCED, CONSTANT_DOUBLE_PRODUCED, CONSTANT_LONG_PRODUCED, CONSTANT_OBJECT_PRODUCED, THIS_PRODUCED, INTEGER_PRODUCED, SHORT_PRODUCED, BYTE_PRODUCED, FLOAT_PRODUCED, BOOLEAN_PRODUCED, CHARACTER_PRODUCED, DOUBLE_PRODUCED, LONG_PRODUCED, OBJECT_PRODUCED, NEW_OBJECT, NEW_ARRAY, INTEGER_ARG, SHORT_ARG, BYTE_ARG, FLOAT_ARG, BOOLEAN_ARG, CHARACTER_ARG, DOUBLE_ARG, LONG_ARG, OBJECT_ARG, GETGRAPHICS, CREATEGRAPHICS, MOUSE_EVENT, KEY_EVENT, WINDOW, IMAGE_SIZE};
        values = EventKind.values();
        assert (values.length <= 64) : "Can't have more than 64 kinds of events because we only use 6 bits of a byte to store the kind.";
    }

    private EventKind(String descriptor, OperandStackType stackType, boolean isConstantProduced, boolean isValueProduced, boolean isObjectProduced, boolean isInvocation, boolean isArgument, boolean isBranch, boolean isDefinition, boolean isInstantiation, boolean loadImmediately, boolean isArtificial) {
        this.stackType = stackType;
        this.isConstantProduced = isConstantProduced;
        this.isValueProduced = isValueProduced;
        this.isObjectProduced = isObjectProduced;
        this.isInvocation = isInvocation;
        this.isArgument = isArgument;
        this.isBranch = isBranch;
        this.isDefinition = isDefinition;
        this.isInstantiation = isInstantiation;
        this.isNonArgumentDefinition = isDefinition && !isArgument;
        this.loadImmediately = loadImmediately;
        this.isArtificial = isArtificial;
        this.name = this.name();
        this.descriptor = descriptor;
    }

    private static String classToInternalTypeName(Class<?> t) {
        String type = t.getName();
        if (type.startsWith("[")) {
            return type;
        }
        if (type.equals("boolean")) {
            return "Z";
        }
        if (type.equals("byte")) {
            return "B";
        }
        if (type.equals("float")) {
            return "F";
        }
        if (type.equals("double")) {
            return "D";
        }
        if (type.equals("char")) {
            return "C";
        }
        if (type.equals("short")) {
            return "S";
        }
        if (type.equals("int")) {
            return "I";
        }
        if (type.equals("long")) {
            return "J";
        }
        if (type.equals("void")) {
            return "V";
        }
        return "L" + type.replace('.', '/') + ";";
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public OperandStackType getStackType() {
        return this.stackType;
    }

    public boolean isDoubleOrLong() {
        return this.stackType.isDoubleOrLong();
    }

    public abstract String getDescription(Trace var1, int var2);

    public abstract String getHTMLDescription(Trace var1, int var2);

    public static EventKind intToEvent(int event) {
        return values[event];
    }

    public static int getNumberOfKinds() {
        return values.length;
    }

    protected String getDescriptionOfSetArgumentEvent(Trace trace, int eventID) {
        return String.valueOf(this.getNameOfArgumentSet(trace, eventID)) + " = " + this.getDescriptionOfSetArgumentValue(trace, eventID);
    }

    protected String getExplanationOfSetMethodArgument(Trace trace, int eventID) {
        return "<b>" + this.getNameOfArgumentSet(trace, eventID) + "</b> was passed <b>" + this.getDescriptionOfSetArgumentValue(trace, eventID) + "</b>";
    }

    protected String getNameOfArgumentSet(Trace trace, int eventID) {
        Instruction inst = trace.getInstruction(eventID);
        return inst.getCode().getLocalIDNameRelativeToInstruction(trace.getArgumentLocalIDSet(eventID), inst);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDescriptionOfSetArgumentValue(Trace trace, int eventID) {
        Object text = null;
        try {
            switch (trace.getKind(eventID)) {
                case OBJECT_ARG: {
                    long val = trace.getObjectIDProduced(eventID);
                    if (val == 0L) {
                        return "null";
                    }
                    Object immutable = trace.getImmutableObject(val);
                    if (immutable instanceof String) {
                        return "\"" + (String)immutable + "\"";
                    }
                    return trace.getDescriptionOfObjectID(val);
                }
                case INTEGER_ARG: {
                    return Integer.toString(trace.getIntegerProduced(eventID));
                }
                case SHORT_ARG: {
                    return Short.toString(trace.getShortProduced(eventID));
                }
                case FLOAT_ARG: {
                    return Float.toString(trace.getFloatProduced(eventID));
                }
                case BOOLEAN_ARG: {
                    return Boolean.toString(trace.getBooleanProduced(eventID));
                }
                case CHARACTER_ARG: {
                    return Character.toString(trace.getCharacterProduced(eventID));
                }
                case DOUBLE_ARG: {
                    return Double.toString(trace.getDoubleProduced(eventID));
                }
                case LONG_ARG: {
                    return Long.toString(trace.getLongProduced(eventID));
                }
            }
            return "unknown type of set argument type: " + (Object)((Object)trace.getKind(eventID));
        }
        catch (NoValueException e) {
            return "?";
        }
    }

    protected String getDescriptionOfObjectProduced(Trace trace, int eventID) {
        Object objectProduced = trace.getObjectProduced(eventID);
        if (objectProduced instanceof String) {
            return "\"" + objectProduced + "\"";
        }
        long objectID = trace.getObjectIDProduced(eventID);
        return objectID < 0L ? "?" : trace.getDescriptionOfObjectID(objectID);
    }

    protected String getExplanationOfValueProduced(Trace trace, int eventID) {
        Instruction inst = trace.getInstruction(eventID);
        String valueText = trace.getKind(eventID).getDescription(trace, eventID);
        valueText = valueText.replace("<", "&lt;");
        valueText = valueText.replace(">", "&gt;");
        valueText = "<b>" + valueText + "</b>";
        if (inst instanceof GetLocal) {
            return "<b>" + ((GetLocal)inst).getLocalIDName() + "</b> was " + valueText;
        }
        if (inst instanceof GetArrayValue) {
            return String.valueOf(trace.getOperandStackValue(eventID, 0).getVerbalExplanation()) + ", and the value at index <b>" + trace.getOperandStackValue(eventID, 1).getDisplayName(true) + "</b> was " + valueText;
        }
        if (inst instanceof PushConstant) {
            return String.valueOf(valueText) + " was a constant";
        }
        if (inst instanceof NEW) {
            return "Instantiated a new <b>" + ((NEW)inst).getClassInstantiated().getName().getSimpleName() + "</b>";
        }
        if (inst instanceof Instantiation) {
            return "a new array was created";
        }
        if (inst instanceof Duplication) {
            return trace.getOperandStackValue(eventID, 0).getVerbalExplanation();
        }
        if (inst instanceof ARRAYLENGTH) {
            return trace.getOperandStackValue(eventID, 0).getVerbalExplanation() + " had " + valueText + " elements";
        }
        if (inst instanceof Invoke) {
            return "<b>" + ((Invoke)inst).getMethodInvoked().getMethodName() + "()</b> returned " + valueText;
        }
        if (inst instanceof CHECKCAST) {
            return "";
        }
        if (inst instanceof UnaryComputation) {
            return String.valueOf(((UnaryComputation)inst).getPastTenseVerb()) + " " + trace.getOperandStackValue(eventID, 0).getDisplayName(true) + " and got " + valueText;
        }
        if (inst instanceof BinaryComputation) {
            return String.valueOf(((BinaryComputation)inst).getPastTenseVerb()) + " " + trace.getOperandStackValue(eventID, 0).getDisplayName(true) + " and " + trace.getOperandStackValue(eventID, 1).getDisplayName(true) + " and got " + valueText;
        }
        if (inst instanceof GETFIELD) {
            return "<b>" + trace.getOperandStackValue(eventID, 0).getDisplayName(true) + "</b>'s field <b>" + ((GETFIELD)inst).getFieldref().getName() + "</b> was " + valueText;
        }
        if (inst instanceof GETSTATIC) {
            return "<b>" + ((GETSTATIC)inst).getFieldref().getClassname().getSimpleName() + "." + ((GETSTATIC)inst).getFieldref().getName() + "</b> was " + valueText;
        }
        if (inst instanceof INSTANCEOF) {
            boolean wasInstanceOf = valueText.equals("true");
            return "<b>" + trace.getOperandStackValue(eventID, 0).getDisplayName(true) + "</b> was " + (wasInstanceOf ? "" : "<b>not</b>") + " an instance of <b>" + ((INSTANCEOF)inst).getClassInfo().getName().getSimpleName() + "</b>.";
        }
        return "";
    }

    protected String getDescriptionOfConstantProduced(Trace trace, int eventID) {
        Instruction inst = trace.getInstruction(eventID);
        Object value = null;
        int memoryDependencyID = trace.getHeapDependency(eventID);
        if (inst instanceof GetLocal) {
            trace.getOperandStackDependencies(eventID);
            assert (memoryDependencyID >= 0) : "Why don't we have a definition for " + inst + "?";
            EventKind memoryKind = trace.getKind(memoryDependencyID);
            if (memoryKind.isArgument) {
                return memoryKind.getDescriptionOfSetArgumentValue(trace, eventID);
            }
            Value valueSet = trace.getDefinitionValueSet(memoryDependencyID);
            assert (valueSet != null) : "Why don't we have a value set for " + trace.getInstruction(memoryDependencyID) + "?";
            try {
                value = valueSet.getValue();
            }
            catch (NoValueException noValueException) {}
        } else if (inst instanceof PushConstant) {
            value = ((PushConstant)inst).getConstant();
        } else if (inst instanceof DUP || inst instanceof DUP_X1 || inst instanceof DUP_X2) {
            try {
                value = trace.getOperandStackValue(eventID, 0).getValue();
            }
            catch (NoValueException memoryKind) {}
        } else if (inst instanceof DUP2 || inst instanceof DUP2_X1 || inst instanceof DUP2_X2) {
            System.err.println(inst + " used value produced by ");
            for (Value producer : trace.getOperandStackDependencies(eventID)) {
                System.err.println("" + producer);
            }
            Whyline.debug("Still don't know how to find the constant values produced by a DUP2 instruction.");
        } else assert (false) : "Don't know how to determine a constant value produced by " + inst.getClass();
        return "" + value;
    }

    public static String getAssignmentHTML(String name, String value) {
        return "<b>" + name + "</b> was assigned <b>" + value + "</b>";
    }

    public static String getInvocationHTML(Trace trace, int eventID) {
        Invoke invoke = (Invoke)trace.getInstruction(eventID);
        String prefix = "Called <b>" + invoke.getJavaMethodName() + "()</b>";
        if (invoke instanceof INVOKESTATIC) {
            return prefix;
        }
        return String.valueOf(prefix) + " on <b>" + trace.getOperandStackValue(eventID, 0).getDisplayName(true) + "</b>";
    }

    public String toString() {
        return this.name;
    }

    public static EventKind[] values() {
        EventKind[] eventKindArray = ENUM$VALUES;
        int n = eventKindArray.length;
        EventKind[] eventKindArray2 = new EventKind[n];
        System.arraycopy(ENUM$VALUES, 0, eventKindArray2, 0, n);
        return eventKindArray2;
    }

    public static EventKind valueOf(String string) {
        return Enum.valueOf(EventKind.class, string);
    }

    /* synthetic */ EventKind(String string, int n, String string2, OperandStackType operandStackType, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, EventKind eventKind) {
        this(string2, operandStackType, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10);
    }
}

