/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.bytecode.PUTFIELD;
import edu.cmu.hcii.whyline.bytecode.PushConstant;
import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.ConstantValueAnswer;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstantValue
extends Value {
    private final PushConstant<?> instruction;

    public ConstantValue(Trace trace, PushConstant<?> instruction) {
        super(trace);
        this.instruction = instruction;
    }

    public PushConstant<?> getInstruction() {
        return this.instruction;
    }

    @Override
    public boolean getBoolean() {
        return (Boolean)this.getValue();
    }

    @Override
    public int getInteger() {
        return (Integer)this.getValue();
    }

    @Override
    public float getFloat() {
        return ((Float)this.getValue()).floatValue();
    }

    @Override
    public double getDouble() {
        return (Double)this.getValue();
    }

    @Override
    public Object getValue() {
        return this.instruction.getConstant();
    }

    @Override
    public Object getImmutable() {
        return this.getValue();
    }

    @Override
    public boolean isObject() {
        return this.getValue() == null || this.getValue() instanceof String;
    }

    @Override
    public long getLong() {
        Object obj = this.getValue();
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof String) {
            return this.trace.getIDOfImmutable(obj);
        }
        throw new RuntimeException("This constant cannot be converted to long; conversion is only for constant objects.");
    }

    @Override
    public String getVerbalExplanation() {
        String valueText = "<b>" + this.getDisplayName(true) + "</b>";
        return String.valueOf(valueText) + " was a constant";
    }

    @Override
    public String getDisplayName(boolean html) {
        Object value = this.getValue();
        if (this.instruction.getConsumers().getFirstConsumer() instanceof PUTFIELD && ((PUTFIELD)this.instruction.getConsumers().getFirstConsumer()).getFieldref().getTypeDescriptor().equals("Z")) {
            return (Integer)value == 0 ? "false" : "true";
        }
        return "" + value;
    }

    @Override
    public boolean hasEventID() {
        return false;
    }

    @Override
    public int getEventID() {
        return -1;
    }

    @Override
    public Answer getAnswer(Question<?> q) {
        return new ConstantValueAnswer(q, this);
    }

    public String toString() {
        return "ConstantStackValue: " + this.instruction;
    }
}

