/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.trace;

import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.trace.CallStackEntry;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.IntegerVector;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallStack
implements Iterable<CallStackEntry> {
    private int eventIDLastExecuted = -1;
    private final Trace trace;
    private final int threadID;
    private final Listener listener;
    private final ArrayList<CallStackEntry> callStack = new ArrayList(3);
    private final ArrayList<InvocationInfo> invocationsWaitingForStartMethods = new ArrayList(2);
    private final IntegerVector startsWaitingForReturns;

    public CallStack(Trace trace, int threadID, int firstEventID, Listener listener) {
        this.eventIDLastExecuted = firstEventID;
        this.trace = trace;
        this.threadID = threadID;
        this.startsWaitingForReturns = new IntegerVector(4);
        this.listener = listener;
        this.handleNextEventID(firstEventID);
    }

    public CallStack(Trace trace, int eventID) {
        this.trace = trace;
        this.eventIDLastExecuted = eventID;
        this.threadID = trace.getThreadID(eventID);
        this.startsWaitingForReturns = null;
        this.listener = null;
        int event = eventID;
        while (event >= 0) {
            int startID = trace.getStartID(event);
            int invocationID = startID >= 0 ? trace.getStartIDsInvocationID(startID) : -1;
            this.callStack.add(0, new CallStackEntry(trace, startID >= 0 ? trace.getInstruction(startID).getMethod() : null, invocationID, startID));
            event = invocationID;
        }
    }

    public CallStack(Trace trace, int threadID, CallStack cs) {
        this.trace = trace;
        this.threadID = threadID;
        this.listener = null;
        if (cs != null) {
            this.eventIDLastExecuted = cs.eventIDLastExecuted;
            for (CallStackEntry m : cs.callStack) {
                this.callStack.add(m);
            }
            this.startsWaitingForReturns = new IntegerVector(cs.startsWaitingForReturns);
            for (InvocationInfo i : cs.invocationsWaitingForStartMethods) {
                this.invocationsWaitingForStartMethods.add(i);
            }
        } else {
            this.startsWaitingForReturns = new IntegerVector(3);
        }
    }

    public int getThreadID() {
        return this.threadID;
    }

    public void handleNextEventID(int eventID) {
        EventKind kind = this.trace.getKind(eventID);
        switch (kind) {
            case START_METHOD: {
                int correspondingInvocationID;
                int invocationWaiting;
                MethodInfo methodStarting = this.trace.getInstruction(eventID).getMethod();
                this.startsWaitingForReturns.push(eventID);
                int n = invocationWaiting = this.invocationsWaitingForStartMethods.isEmpty() ? -1 : this.invocationsWaitingForStartMethods.get((int)(this.invocationsWaitingForStartMethods.size() - 1)).invocationEventID;
                int n2 = methodStarting.isImplicitlyInvoked() ? -1 : (correspondingInvocationID = invocationWaiting < 0 ? -1 : this.invocationsWaitingForStartMethods.remove((int)(this.invocationsWaitingForStartMethods.size() - 1)).invocationEventID);
                if (correspondingInvocationID >= 0 && !((Invoke)this.trace.getInstruction(correspondingInvocationID)).getMethodInvoked().getMethodNameAndDescriptor().equals(methodStarting.getMethodNameAndDescriptor())) {
                    correspondingInvocationID = -1;
                }
                if (correspondingInvocationID >= 0 && this.listener != null) {
                    this.listener.foundInvocationStartPair(correspondingInvocationID, eventID);
                }
                this.callStack.add(new CallStackEntry(this.trace, methodStarting, correspondingInvocationID, eventID));
                break;
            }
            case RETURN: {
                MethodInfo methodReturning = this.trace.getInstruction(eventID).getMethod();
                if (this.startsWaitingForReturns.size() > 0) {
                    int correspondingStartEventID = this.startsWaitingForReturns.pop();
                    if (this.listener != null) {
                        this.listener.foundStartReturnOrCatchPair(correspondingStartEventID, eventID);
                    }
                    this.callStack.remove(this.callStack.size() - 1);
                }
                this.popInvocationsThatWereNotTraced();
                break;
            }
            case EXCEPTION_CAUGHT: {
                MethodInfo methodWithException = this.trace.getInstruction(eventID).getMethod();
                while (!this.callStack.isEmpty() && this.callStack.get(this.callStack.size() - 1).getMethod() != methodWithException) {
                    this.callStack.remove(this.callStack.size() - 1);
                    if (this.listener == null) continue;
                    this.listener.foundStartReturnOrCatchPair(this.startsWaitingForReturns.pop(), eventID);
                }
                this.popInvocationsThatWereNotTraced();
                assert (!this.callStack.isEmpty()) : "An exception can't pop ALL the frames off the stack. It must have been caught somewhere.";
                break;
            }
            case INVOKE_VIRTUAL: 
            case INVOKE_SPECIAL: 
            case INVOKE_STATIC: 
            case INVOKE_INTERFACE: {
                this.invocationsWaitingForStartMethods.add(new InvocationInfo(eventID, this.callStack.size()));
            }
        }
        this.eventIDLastExecuted = eventID;
    }

    private void popInvocationsThatWereNotTraced() {
        int currentDepth = this.callStack.size();
        while (this.invocationsWaitingForStartMethods.size() > 0 && this.invocationsWaitingForStartMethods.get((int)(this.invocationsWaitingForStartMethods.size() - 1)).depth > currentDepth) {
            this.invocationsWaitingForStartMethods.remove(this.invocationsWaitingForStartMethods.size() - 1);
        }
    }

    @Override
    public Iterator<CallStackEntry> iterator() {
        return this.callStack.iterator();
    }

    public CallStackEntry getEntryAt(int index) {
        return this.callStack.get(index);
    }

    public CallStackEntry getEntryOnTop() {
        return this.callStack.isEmpty() ? null : this.callStack.get(this.callStack.size() - 1);
    }

    public int getEventIDLastExecuted() {
        return this.eventIDLastExecuted;
    }

    public int getDepth() {
        return this.callStack.size();
    }

    public String toString() {
        String s = "Call stack for thread " + this.trace.getThreadName(this.threadID) + "\n\nafter executing " + this.eventIDLastExecuted;
        int i = this.callStack.size() - 1;
        while (i >= 0) {
            s = String.valueOf(s) + "\n" + this.callStack.get(i).getMethod().getQualifiedNameAndDescriptor();
            --i;
        }
        return s;
    }

    private static class InvocationInfo {
        public final int invocationEventID;
        public final int depth;

        public InvocationInfo(int invocationEventID, int depth) {
            this.invocationEventID = invocationEventID;
            this.depth = depth;
        }
    }

    public static interface Listener {
        public void foundInvocationStartPair(int var1, int var2);

        public void foundStartReturnOrCatchPair(int var1, int var2);
    }
}

