/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.source.JavaParserConstants;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.LineNumber;
import edu.cmu.hcii.whyline.source.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Token
implements Comparable<Token>,
JavaParserConstants {
    private int indexOnLine = -1;
    private final Line line;
    private String token;
    public final int kind;

    public Token(Line line, String token, int kind) {
        this.line = line;
        this.token = token.intern();
        this.kind = kind;
    }

    public Line getLine() {
        return this.line;
    }

    public int getKind() {
        return this.kind;
    }

    public String getText() {
        return this.token;
    }

    public void setText(String text) {
        this.token = text;
    }

    public FileInterface getFile() {
        return this.line.getFile();
    }

    public Token getNext() {
        Token next = this.line.getTokenAfter(this);
        if (next != null) {
            return next;
        }
        try {
            Line nextLine = this.line.getLineAfter();
            if (nextLine != null) {
                return nextLine.getFirstToken();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return null;
    }

    public Token getNextCodeToken() throws ParseException {
        return this.line.getFile().getCodeTokenAfter(this);
    }

    public Token getPreviousCodeToken() throws ParseException {
        return this.line.getFile().getCodeTokenBefore(this);
    }

    public void setLineIndex(int index) {
        this.indexOnLine = index;
    }

    public int getLineIndex() {
        return this.indexOnLine;
    }

    public boolean isWhitespace() {
        return this.kind == 129;
    }

    public boolean isComment() {
        return this.kind == 8 || this.kind == 10;
    }

    public boolean isCode() {
        return !this.isWhitespaceOrComment();
    }

    public boolean isWhitespaceOrComment() {
        return this.isWhitespace() || this.isComment();
    }

    public LineNumber getLineNumber() {
        return this.line.getLineNumber();
    }

    public MethodInfo getMethod() {
        return this.line.getMethod();
    }

    public boolean isAfter(Token t) {
        assert (this.line.getFile() == t.getLine().getFile()) : "Can't compare tokens in different files.";
        if (this.line.getLineNumber().is(t.getLineNumber())) {
            return this.indexOnLine > t.indexOnLine;
        }
        return this.line.getLineNumber().isAfter(t.getLineNumber());
    }

    public boolean isIdentifier() {
        return this.kind == 76;
    }

    public boolean isPrimitive() {
        switch (this.kind) {
            case 14: 
            case 16: 
            case 19: 
            case 25: 
            case 32: 
            case 39: 
            case 41: 
            case 50: {
                return true;
            }
        }
        return false;
    }

    public boolean isLiteral() {
        switch (this.kind) {
            case 29: 
            case 44: 
            case 60: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 74: 
            case 75: {
                return true;
            }
        }
        return false;
    }

    public boolean isTestOperator() {
        switch (this.kind) {
            case 90: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    public boolean isOperator() {
        switch (this.kind) {
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    public boolean isDelimiter() {
        switch (this.kind) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return true;
            }
        }
        return false;
    }

    public boolean isModifier() {
        switch (this.kind) {
            case 12: 
            case 30: 
            case 42: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 55: 
            case 59: 
            case 63: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.token;
    }

    @Override
    public int compareTo(Token token) {
        if (this.line.getFile() == token.line.getFile()) {
            LineNumber thatLine;
            LineNumber thisLine = this.line.getLineNumber();
            if (thisLine == (thatLine = token.line.getLineNumber())) {
                return this.indexOnLine - token.indexOnLine;
            }
            return thisLine.compareTo(thatLine);
        }
        return this.line.getFile().compareTo(token.line.getFile());
    }

    public static class GreaterThanToken
    extends Token {
        public final int realKind;

        public GreaterThanToken(Line line, String token, int kind, int realKind) {
            super(line, token, kind);
            this.realKind = realKind;
        }
    }

    public static class PairedToken
    extends Token {
        private PairedToken associatedToken;

        public PairedToken(Line line, String token, int kind) {
            super(line, token, kind);
        }

        public void setAssociatedToken(PairedToken token) {
            this.associatedToken = token;
        }

        public PairedToken getAssociatedToken() {
            return this.associatedToken;
        }

        public boolean isLeft() {
            return this.kind == 81 || this.kind == 83 || this.kind == 79 || this.kind == 90;
        }
    }
}

