/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import java.io.EOFException;

public class PeekReader {
    private byte[] chars;
    private int index = 0;
    private StringBuilder accumulation = new StringBuilder(20);
    private int currentIndexIsUnicodeEscapeCache = -1;
    private int nextCharCache = 65535;

    public PeekReader(byte[] ascii) {
        this.chars = ascii;
    }

    public char peekAtNext() throws EOFException {
        return this.getNextChar();
    }

    public boolean nextIs(char c) throws EOFException {
        return this.getNextChar() == c;
    }

    public boolean nextIs(char c1, char c2) throws EOFException {
        return this.getNextChar() == c1 && this.getCharAfterNext() == c2;
    }

    public boolean nextIs(char c1, char c2, char c3) throws EOFException {
        return this.getNextChar() == c1 && this.getCharAfterNext() == c2 && this.getCharAfterCharAfterNext() == c3;
    }

    public boolean nextIs(char c1, char c2, char c3, char c4) throws EOFException {
        return this.getNextChar() == c1 && this.getCharAfterNext() == c2 && this.getCharAfterCharAfterNext() == c3 && this.getCharAfterCharAfterCharAfterNext() == c4;
    }

    public char next() throws EOFException {
        char c = this.getNextChar();
        if (c == '\t') {
            this.accumulation.append("    ");
        } else {
            this.accumulation.append(c);
        }
        this.index = this.charAtIndexIsUnicodeEscape(this.index) ? (this.index += 6) : ++this.index;
        this.currentIndexIsUnicodeEscapeCache = -1;
        this.nextCharCache = 65535;
        return c;
    }

    private boolean charAtIndexIsUnicodeEscape(int i) {
        if (this.currentIndexIsUnicodeEscapeCache < 0) {
            int n = this.currentIndexIsUnicodeEscapeCache = (char)this.chars[i] == '\\' && i + 5 < this.chars.length && (char)this.chars[i + 1] == 'u' && Character.isLetterOrDigit((char)this.chars[i + 2]) && Character.isLetterOrDigit((char)this.chars[i + 3]) && Character.isLetterOrDigit((char)this.chars[i + 4]) && Character.isLetterOrDigit((char)this.chars[i + 5]) ? 1 : 0;
        }
        return this.currentIndexIsUnicodeEscapeCache == 1;
    }

    private char readUnicodeEscapeAt(int i) {
        byte one = this.chars[i + 2];
        int two = this.chars[i + 3] * 16 + one;
        int three = this.chars[i + 4] * 256 + two;
        int four = this.chars[i + 5] * 4096 + three;
        char c = (char)four;
        return c;
    }

    private char getNextChar() throws EOFException {
        if (this.nextCharCache == 65535) {
            if (this.index >= this.chars.length) {
                throw new EOFException();
            }
            this.nextCharCache = this.charAtIndexIsUnicodeEscape(this.index) ? (int)this.readUnicodeEscapeAt(this.index) : this.chars[this.index];
        }
        return (char)this.nextCharCache;
    }

    private char getCharAfterNext() {
        int newIndex = this.index;
        newIndex = this.charAtIndexIsUnicodeEscape(newIndex) ? (newIndex += 6) : ++newIndex;
        if (this.charAtIndexIsUnicodeEscape(newIndex)) {
            return this.readUnicodeEscapeAt(newIndex);
        }
        return (char)this.chars[newIndex];
    }

    private char getCharAfterCharAfterNext() {
        int newIndex = this.index;
        newIndex = this.charAtIndexIsUnicodeEscape(newIndex) ? (newIndex += 6) : ++newIndex;
        newIndex = this.charAtIndexIsUnicodeEscape(newIndex) ? (newIndex += 6) : ++newIndex;
        if (this.charAtIndexIsUnicodeEscape(newIndex)) {
            return this.readUnicodeEscapeAt(newIndex);
        }
        return (char)this.chars[newIndex];
    }

    private char getCharAfterCharAfterCharAfterNext() {
        int newIndex = this.index;
        newIndex = this.charAtIndexIsUnicodeEscape(newIndex) ? (newIndex += 6) : ++newIndex;
        newIndex = this.charAtIndexIsUnicodeEscape(newIndex) ? (newIndex += 6) : ++newIndex;
        newIndex = this.charAtIndexIsUnicodeEscape(newIndex) ? (newIndex += 6) : ++newIndex;
        if (this.charAtIndexIsUnicodeEscape(newIndex)) {
            return this.readUnicodeEscapeAt(newIndex);
        }
        return (char)this.chars[newIndex];
    }

    public String eraseAccumulation() {
        String acc = this.accumulation.toString();
        this.accumulation.delete(0, this.accumulation.length());
        return acc;
    }

    public char lastCharReturned() {
        return (char)this.chars[this.index - 1];
    }
}

