/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.NameAndTypeInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.source.ClassBodyElement;
import edu.cmu.hcii.whyline.source.JavaElement;
import edu.cmu.hcii.whyline.source.JavaParser;
import edu.cmu.hcii.whyline.source.Parameter;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.source.Token;
import java.util.ArrayList;

public class ParametersElement
extends JavaElement {
    private ArrayList<Token> identifiers;
    private ArrayList<String> types;

    public ParametersElement(ClassBodyElement parent, Token first, Token last) {
        super(parent, first, last);
    }

    protected void parse(JavaParser.TokenIterator tokens) throws ParseException {
        this.identifiers = new ArrayList();
        this.types = new ArrayList();
        tokens.getNext();
        while (tokens.hasNext() && !tokens.nextKindIs(80)) {
            if (tokens.nextKindIs(30)) {
                tokens.getNext();
            }
            this.optionalAnnotations(tokens);
            String type = this.type(tokens);
            if (tokens.nextKindIs(123)) {
                tokens.getNext();
                type = "[" + type;
            }
            Token name = tokens.getNext();
            String moreBrackets = this.optionalBrackets(tokens);
            this.types.add(String.valueOf(moreBrackets) + type);
            this.identifiers.add(name);
            if (!tokens.nextKindIs(86)) continue;
            tokens.getNext();
        }
        tokens.getNext();
    }

    public String getSimpleDescriptor() {
        this.parse();
        StringBuilder builder = new StringBuilder("(");
        for (String type : this.types) {
            builder.append(NameAndTypeInfo.sourceTypeToDescriptorType(type));
        }
        builder.append(")");
        return builder.toString();
    }

    public Token getIdentifierOfParameter(int number) {
        this.parse();
        return number < 1 || number > this.identifiers.size() ? null : this.identifiers.get(number - 1);
    }

    public void associateTokens(MethodInfo method) throws ParseException {
        int arg = 0;
        for (Token name : this.identifiers) {
            Token type = name.getPreviousCodeToken();
            while (type != null && type.kind != 76 && type != this.firstToken) {
                type = type.getPreviousCodeToken();
            }
            if (type != null && type != this.firstToken) {
                QualifiedClassName classname = method.getParsedDescriptor().getTypeOfArgumentNumber(arg);
                this.getSource().linkTokenWithClassname(type, classname);
            }
            this.getSource().linkTokenWithParameter(name, new Parameter(method, method.isStatic() ? arg : arg + 1));
            ++arg;
        }
    }
}

