/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.LineNumber;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.source.PeekReader;
import edu.cmu.hcii.whyline.source.Token;
import gnu.trove.TObjectIntHashMap;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaTokenizer {
    private final JavaSourceFile source;
    private final PeekReader reader;
    private final ArrayList<Line> lines = new ArrayList();
    private final ArrayList<Token> identifiers = new ArrayList();
    private final ArrayList<Token> code = new ArrayList();
    private final Map<Token, String> javadocs = new HashMap<Token, String>();
    private final TObjectIntHashMap<Line> codeTokenIndicesByLine = new TObjectIntHashMap(50);
    private Line currentLine;
    private boolean currentLineIndents = false;
    private Stack<Token> indentationTokens = new Stack();
    private boolean currentLineHasBrace = false;
    private boolean currentLineHasSemiColon = false;
    private boolean currentLineHasCode = false;
    private boolean currentLineHasColon = false;
    private boolean waitingForSemiColons = false;

    public JavaTokenizer(JavaSourceFile source, byte[] bytes) throws ParseException {
        this.source = source;
        this.reader = new PeekReader(bytes);
        this.tokenize();
    }

    public TObjectIntHashMap<Line> getCodeTokenIndiciesByLine() {
        return this.codeTokenIndicesByLine;
    }

    public Line[] getLines() {
        Line[] array = new Line[this.lines.size()];
        this.lines.toArray(array);
        return array;
    }

    public Token[] getIdentifiers() {
        Token[] array = new Token[this.identifiers.size()];
        this.identifiers.toArray(array);
        return array;
    }

    public Token[] getCode() {
        Token[] array = new Token[this.code.size()];
        this.code.toArray(array);
        return array;
    }

    public Map<Token, String> getJavaDocsByToken() {
        return this.javadocs;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private void tokenize() throws ParseException {
        block21: {
            this.codeTokenIndicesByLine.clear();
            this.currentLine = new Line(new LineNumber(this.source, 1), new Token[0]);
            tokenStack = new Stack<Token.PairedToken>();
            try {
                while (true) {
                    javadoc = this.readWhitespace();
                    newToken = this.readCodeToken();
                    if (!JavaTokenizer.$assertionsDisabled && newToken == null) {
                        throw new AssertionError((Object)("Somehow, we didn't construct a token from the next character, which was '" + this.reader.next() + "'" + ".\n" + "The file was " + this.source.getFileName() + "\n" + "The context was\n\n" + this.currentLine));
                    }
                    this.currentLineHasCode = true;
                    kind = newToken.kind;
                    if (javadoc != null) {
                        this.javadocs.put(newToken, javadoc);
                    }
                    this.currentLine.addToken(newToken);
                    this.code.add(newToken);
                    switch (kind) {
                        case 56: 
                        case 76: {
                            this.identifiers.add(newToken);
                            break;
                        }
                        case 81: 
                        case 82: {
                            this.currentLineHasBrace = true;
                            break;
                        }
                        case 85: {
                            this.currentLineHasSemiColon = true;
                            break;
                        }
                        case 94: {
                            this.currentLineHasColon = true;
                        }
                    }
                    switch (kind) {
                        case 79: 
                        case 81: 
                        case 83: {
                            tokenStack.push((Token.PairedToken)newToken);
                            break;
                        }
                        case 80: 
                        case 82: 
                        case 84: {
                            open = (Token.PairedToken)tokenStack.pop();
                            if (open.kind == 79 && newToken.kind != 80 || open.kind == 83 && newToken.kind != 84 || open.kind == 81 && newToken.kind != 82) {
                                throw new ParseException("\n\nOn" + newToken.getLineNumber() + "\n\tCan't match " + open.getLineNumber() + " " + open + " with " + newToken.getLineNumber() + " " + newToken, null);
                            }
                            open.setAssociatedToken((Token.PairedToken)newToken);
                            ((Token.PairedToken)newToken).setAssociatedToken(open);
                        }
                    }
                    switch (this.getIndentationChangeFor(kind)) {
                        case 1: {
                            this.indentationTokens.push(newToken);
                            break;
                        }
                        case -1: {
                            this.indentationTokens.pop();
                        }
                    }
                    if (this.codeTokenIndicesByLine.containsKey(this.currentLine)) continue;
                    this.codeTokenIndicesByLine.put(this.currentLine, this.code.size() - 1);
                }
            }
            catch (EOFException javadoc) {
                this.nextLine();
                if (tokenStack.size() <= 0) break block21;
                System.err.println("Warning: parens, brackets, and braces didn't match up. Here's the stack:");
                ** for (t : tokenStack)
            }
lbl-1000:
            // 1 sources

            {
                System.err.println("\t'" + t.getText() + "\"");
                continue;
            }
        }
        this.codeTokenIndicesByLine.trimToSize();
    }

    private int getIndentationChangeFor(int kind) {
        switch (kind) {
            case 81: {
                return 1;
            }
            case 82: {
                return -1;
            }
        }
        return 0;
    }

    private Token readCodeToken() throws EOFException {
        block68: {
            block70: {
                block69: {
                    if (this.reader.nextIs('@')) {
                        this.reader.next();
                        return new Token(this.currentLine, this.reader.eraseAccumulation(), 88);
                    }
                    if (this.reader.nextIs('\"')) {
                        this.reader.next();
                        while (true) {
                            if (this.reader.nextIs('\\')) {
                                this.reader.next();
                                this.reader.next();
                                continue;
                            }
                            if (this.reader.nextIs('\"')) break;
                            this.reader.next();
                        }
                        this.reader.next();
                        return new Token(this.currentLine, this.reader.eraseAccumulation(), 75);
                    }
                    if (!this.reader.nextIs('\'')) break block68;
                    this.reader.next();
                    if (!this.reader.nextIs('\\')) break block69;
                    this.reader.next();
                    char next = this.reader.peekAtNext();
                    switch (next) {
                        case '\"': 
                        case '\'': 
                        case '\\': 
                        case 'b': 
                        case 'f': 
                        case 'n': 
                        case 'r': 
                        case 't': {
                            this.reader.next();
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            this.reader.next();
                            next = this.reader.peekAtNext();
                            if (!Character.isDigit(next) || next == '8' || next == '9') break block70;
                            this.reader.next();
                            next = this.reader.peekAtNext();
                            if (!Character.isDigit(next) || next == '8' || next == '9') break block70;
                            this.reader.next();
                        }
                        default: {
                            break;
                        }
                        {
                        }
                    }
                    break block70;
                }
                this.reader.next();
            }
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 74);
        }
        if (Character.isDigit(this.reader.peekAtNext())) {
            String number;
            this.reader.next();
            while (Character.isDigit(this.reader.peekAtNext()) || this.reader.nextIs('.') || Character.isLetter(this.reader.peekAtNext())) {
                this.reader.next();
            }
            return new Token(this.currentLine, number, (number = this.reader.eraseAccumulation()).contains(".") ? 69 : 65);
        }
        if (this.reader.nextIs('(')) {
            this.reader.next();
            return new Token.PairedToken(this.currentLine, this.reader.eraseAccumulation(), 79);
        }
        if (this.reader.nextIs(')')) {
            this.reader.next();
            return new Token.PairedToken(this.currentLine, this.reader.eraseAccumulation(), 80);
        }
        if (this.reader.nextIs('[')) {
            this.reader.next();
            return new Token.PairedToken(this.currentLine, this.reader.eraseAccumulation(), 83);
        }
        if (this.reader.nextIs(']')) {
            this.reader.next();
            return new Token.PairedToken(this.currentLine, this.reader.eraseAccumulation(), 84);
        }
        if (this.reader.nextIs('{')) {
            this.reader.next();
            return new Token.PairedToken(this.currentLine, this.reader.eraseAccumulation(), 81);
        }
        if (this.reader.nextIs('}')) {
            this.reader.next();
            return new Token.PairedToken(this.currentLine, this.reader.eraseAccumulation(), 82);
        }
        if (this.reader.nextIs('.', '.', '.')) {
            this.reader.next();
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 123);
        }
        if (this.reader.nextIs('.')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 87);
        }
        if (this.reader.nextIs(';')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 85);
        }
        if (this.reader.nextIs(',')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 86);
        }
        if (Character.isJavaIdentifierStart(this.reader.peekAtNext())) {
            this.reader.next();
            while (Character.isJavaIdentifierPart(this.reader.peekAtNext())) {
                this.reader.next();
            }
            String text = this.reader.eraseAccumulation();
            int type = JavaTokenizer.getTypeOfIdentifier(text);
            return new Token(this.currentLine, text, type);
        }
        if (this.reader.nextIs('>', '>', '>', '=')) {
            this.reader.next();
            this.reader.next();
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 122);
        }
        if (this.reader.nextIs('>', '>', '=')) {
            this.reader.next();
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 121);
        }
        if (this.reader.nextIs('<', '<', '=')) {
            this.reader.next();
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 120);
        }
        if (this.reader.nextIs('=', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 95);
        }
        if (this.reader.nextIs('<', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 96);
        }
        if (this.reader.nextIs('>', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 97);
        }
        if (this.reader.nextIs('!', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 98);
        }
        if (this.reader.nextIs('&', '&')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 100);
        }
        if (this.reader.nextIs('|', '|')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 99);
        }
        if (this.reader.nextIs('<', '<')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 111);
        }
        if (this.reader.nextIs('+', '+')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 101);
        }
        if (this.reader.nextIs('-', '-')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 102);
        }
        if (this.reader.nextIs('+', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 112);
        }
        if (this.reader.nextIs('-', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 113);
        }
        if (this.reader.nextIs('*', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 114);
        }
        if (this.reader.nextIs('/', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 115);
        }
        if (this.reader.nextIs('&', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 116);
        }
        if (this.reader.nextIs('|', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 117);
        }
        if (this.reader.nextIs('^', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 118);
        }
        if (this.reader.nextIs('%', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 119);
        }
        if (this.reader.nextIs('%', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 119);
        }
        if (this.reader.nextIs('%', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 119);
        }
        if (this.reader.nextIs('%', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 119);
        }
        if (this.reader.nextIs('%', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 119);
        }
        if (this.reader.nextIs('%', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 119);
        }
        if (this.reader.nextIs('%', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 119);
        }
        if (this.reader.nextIs('%', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 119);
        }
        if (this.reader.nextIs('%', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 119);
        }
        if (this.reader.nextIs('%', '=')) {
            this.reader.next();
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 119);
        }
        if (this.reader.nextIs('>')) {
            this.reader.next();
            return new Token.GreaterThanToken(this.currentLine, this.reader.eraseAccumulation(), 126, this.reader.nextIs('>', '>') ? 125 : (this.reader.nextIs('>', '>', '>') ? 124 : 126));
        }
        if (this.reader.nextIs('<')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 90);
        }
        if (this.reader.nextIs(':')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 94);
        }
        if (this.reader.nextIs('?')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 93);
        }
        if (this.reader.nextIs('!')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 91);
        }
        if (this.reader.nextIs('~')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 92);
        }
        if (this.reader.nextIs('+')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 103);
        }
        if (this.reader.nextIs('-')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 104);
        }
        if (this.reader.nextIs('&')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 107);
        }
        if (this.reader.nextIs('|')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 108);
        }
        if (this.reader.nextIs('^')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 109);
        }
        if (this.reader.nextIs('*')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 105);
        }
        if (this.reader.nextIs('/')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 106);
        }
        if (this.reader.nextIs('%')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 110);
        }
        if (this.reader.nextIs('=')) {
            this.reader.next();
            return new Token(this.currentLine, this.reader.eraseAccumulation(), 89);
        }
        throw new RuntimeException("Unknown type of Java token: " + this.reader.eraseAccumulation());
    }

    private String readWhitespace() throws EOFException {
        String javadoc = null;
        while (this.reader.nextIs('/', '/') || this.reader.nextIs('/', '*') || this.reader.nextIs('\f') || this.reader.nextIs(' ') || this.reader.nextIs('\t') || this.reader.nextIs('\n') || this.reader.nextIs('\r')) {
            if (this.reader.nextIs('/', '/')) {
                this.reader.next();
                this.reader.next();
                while (!this.reader.nextIs('\n') && !this.reader.nextIs('\r')) {
                    this.reader.next();
                }
                this.currentLine.addToken(new Token(this.currentLine, this.reader.eraseAccumulation(), 8));
                continue;
            }
            if (this.reader.nextIs('/', '*')) {
                String multiLineComment;
                StringBuilder javadocBuilder = new StringBuilder();
                this.reader.next();
                this.reader.next();
                while (!this.reader.nextIs('*', '/')) {
                    if (this.reader.nextIs('\r') || this.reader.nextIs('\n')) {
                        if (this.reader.nextIs('\r', '\n')) {
                            this.reader.next();
                            this.reader.next();
                        } else {
                            this.reader.next();
                        }
                        multiLineComment = this.reader.eraseAccumulation();
                        this.currentLine.addToken(new Token(this.currentLine, multiLineComment, 10));
                        this.nextLine();
                        javadocBuilder.append(multiLineComment);
                        continue;
                    }
                    this.reader.next();
                }
                this.reader.next();
                this.reader.next();
                multiLineComment = this.reader.eraseAccumulation();
                Token token = new Token(this.currentLine, multiLineComment, 10);
                this.currentLine.addToken(token);
                javadocBuilder.append(multiLineComment);
                String doc = javadocBuilder.toString();
                if (!doc.trim().startsWith("/**")) continue;
                javadoc = doc;
                continue;
            }
            if (this.reader.nextIs('\f') || this.reader.nextIs(' ') || this.reader.nextIs('\t')) {
                while (this.reader.nextIs('\f') || this.reader.nextIs(' ') || this.reader.nextIs('\t')) {
                    this.reader.next();
                }
                String whitespace = this.reader.eraseAccumulation();
                this.currentLine.addToken(new Token(this.currentLine, whitespace, 129));
                continue;
            }
            if (!this.reader.nextIs('\r') && !this.reader.nextIs('\n')) continue;
            this.reader.next();
            if (this.reader.lastCharReturned() == '\r' && this.reader.nextIs('\n')) {
                this.reader.next();
            }
            this.nextLine();
            this.reader.eraseAccumulation();
        }
        return javadoc;
    }

    private void nextLine() {
        if (this.waitingForSemiColons && this.currentLineHasBrace) {
            this.indentationTokens.pop();
            this.waitingForSemiColons = false;
        }
        boolean currentLineIndents = this.indentationTokens.size() > 0 && this.indentationTokens.peek().getLine() == this.currentLine;
        this.currentLine.trim();
        this.format(this.currentLine, this.indentationTokens.size() - (currentLineIndents ? 1 : 0));
        this.lines.add(this.currentLine);
        if (this.currentLineHasCode && !this.currentLineHasBrace && !this.currentLineHasColon && !this.currentLineHasSemiColon) {
            if (!this.waitingForSemiColons) {
                this.indentationTokens.push(this.currentLine.getToken(0));
                this.waitingForSemiColons = true;
            }
        } else if (this.waitingForSemiColons && this.currentLineHasSemiColon) {
            this.indentationTokens.pop();
            this.waitingForSemiColons = false;
        }
        this.currentLine = new Line(new LineNumber(this.source, this.lines.size() + 1), new Token[0]);
        this.currentLineHasBrace = false;
        this.currentLineHasSemiColon = false;
        this.currentLineHasCode = false;
        this.currentLineHasColon = false;
    }

    private void format(Line line, int depth) {
        Token leadingWhitespace = line.getToken(0);
        if (leadingWhitespace != null) {
            String text = leadingWhitespace.getText();
            int length = text.length();
            int index = 0;
            while (index < length) {
                char c = text.charAt(index);
                if (c != ' ' && c != '\t') break;
                ++index;
            }
            String rest = text.substring(index);
            StringBuilder formatted = new StringBuilder();
            int i = 0;
            while (i < depth) {
                formatted.append('\t');
                ++i;
            }
            formatted.append(rest);
            leadingWhitespace.setText(formatted.toString());
        }
    }

    private static final int getTypeOfIdentifier(String text) {
        char firstChar = text.charAt(0);
        switch (firstChar) {
            case 'a': {
                if (text.equals("abstract")) {
                    return 12;
                }
                if (!text.equals("assert")) break;
                return 13;
            }
            case 'b': {
                if (text.equals("boolean")) {
                    return 14;
                }
                if (text.equals("break")) {
                    return 15;
                }
                if (!text.equals("byte")) break;
                return 16;
            }
            case 'c': {
                if (text.equals("case")) {
                    return 17;
                }
                if (text.equals("catch")) {
                    return 18;
                }
                if (text.equals("char")) {
                    return 19;
                }
                if (text.equals("class")) {
                    return 20;
                }
                if (text.equals("const")) {
                    return 21;
                }
                if (!text.equals("continue")) break;
                return 22;
            }
            case 'd': {
                if (text.equals("default")) {
                    return 23;
                }
                if (text.equals("do")) {
                    return 24;
                }
                if (!text.equals("double")) break;
                return 25;
            }
            case 'e': {
                if (text.equals("else")) {
                    return 26;
                }
                if (!text.equals("extends")) break;
                return 28;
            }
            case 'f': {
                if (text.equals("false")) {
                    return 29;
                }
                if (text.equals("final")) {
                    return 30;
                }
                if (text.equals("finally")) {
                    return 31;
                }
                if (text.equals("float")) {
                    return 32;
                }
                if (!text.equals("for")) break;
                return 33;
            }
            case 'g': {
                if (!text.equals("goto")) break;
                return 34;
            }
            case 'h': {
                break;
            }
            case 'i': {
                if (text.equals("if")) {
                    return 35;
                }
                if (text.equals("implements")) {
                    return 36;
                }
                if (text.equals("import")) {
                    return 37;
                }
                if (text.equals("instanceof")) {
                    return 38;
                }
                if (text.equals("int")) {
                    return 39;
                }
                if (!text.equals("interface")) break;
                return 40;
            }
            case 'j': {
                break;
            }
            case 'k': {
                break;
            }
            case 'l': {
                if (!text.equals("long")) break;
                return 41;
            }
            case 'm': {
                break;
            }
            case 'n': {
                if (text.equals("null")) {
                    return 44;
                }
                if (text.equals("native")) {
                    return 42;
                }
                if (!text.equals("new")) break;
                return 43;
            }
            case 'o': {
                break;
            }
            case 'p': {
                if (text.equals("package")) {
                    return 45;
                }
                if (text.equals("private")) {
                    return 46;
                }
                if (text.equals("protected")) {
                    return 47;
                }
                if (!text.equals("public")) break;
                return 48;
            }
            case 'q': {
                break;
            }
            case 'r': {
                if (!text.equals("return")) break;
                return 49;
            }
            case 's': {
                if (text.equals("short")) {
                    return 50;
                }
                if (text.equals("static")) {
                    return 51;
                }
                if (text.equals("strictfp")) {
                    return 52;
                }
                if (text.equals("super")) {
                    return 53;
                }
                if (text.equals("switch")) {
                    return 54;
                }
                if (!text.equals("synchronized")) break;
                return 55;
            }
            case 't': {
                if (text.equals("true")) {
                    return 60;
                }
                if (text.equals("this")) {
                    return 56;
                }
                if (text.equals("throw")) {
                    return 57;
                }
                if (text.equals("throws")) {
                    return 58;
                }
                if (text.equals("transient")) {
                    return 59;
                }
                if (!text.equals("try")) break;
                return 61;
            }
            case 'u': {
                break;
            }
            case 'v': {
                if (text.equals("void")) {
                    return 62;
                }
                if (!text.equals("volatile")) break;
                return 63;
            }
            case 'w': {
                if (!text.equals("while")) break;
                return 64;
            }
            case 'y': {
                break;
            }
            case 'x': {
                break;
            }
            case 'z': {
                break;
            }
        }
        return 76;
    }
}

