/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import edu.cmu.hcii.whyline.bytecode.AbstractReturn;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.Computation;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.GetArrayValue;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.PushConstant;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.SetArrayValue;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import edu.cmu.hcii.whyline.source.ClassBodyElement;
import edu.cmu.hcii.whyline.source.ClassElement;
import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.source.JavaParser;
import edu.cmu.hcii.whyline.source.JavaParserConstants;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.Parameter;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.source.TokenRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaSourceFile
implements FileInterface,
Comparable<FileInterface>,
JavaParserConstants {
    public static final String TAB = "    ";
    private String filename;
    private byte[] fileBytes;
    private final boolean isFamiliar;
    private JavaParser parser;
    private ParseException tokenizationProblem = null;
    private final Set<Classfile> classfiles = new HashSet<Classfile>(1);
    private final Map<Token, QualifiedClassName> classnamesByToken = new HashMap<Token, QualifiedClassName>();
    private final Map<Token, Instruction> instructionsByToken = new HashMap<Token, Instruction>();
    private final Map<Instruction, TokenRange> tokensByInstruction = new HashMap<Instruction, TokenRange>();
    private final Map<Token, Parameter> parametersByToken = new HashMap<Token, Parameter>();

    public JavaSourceFile(String filename, byte[] bytes, boolean isFamiliar) throws IOException {
        this.filename = filename;
        this.fileBytes = bytes;
        this.isFamiliar = isFamiliar;
    }

    @Override
    public boolean isFamiliar() {
        return this.isFamiliar;
    }

    private JavaParser getTokens() throws ParseException {
        if (this.tokenizationProblem != null) {
            this.tokenizationProblem.printStackTrace();
            return null;
        }
        if (this.parser == null) {
            try {
                this.parser = new JavaParser(this, this.fileBytes);
            }
            catch (ParseException e) {
                this.tokenizationProblem = e;
                throw e;
            }
            this.fileBytes = null;
        }
        return this.parser;
    }

    public JavaParser.TokenIterator getTokenIterator(Token first, Token last) throws ParseException {
        return this.getTokens().getTokenIterator(first, last);
    }

    @Override
    public int compareTo(FileInterface o) {
        return this.getShortFileName().compareTo(o.getShortFileName());
    }

    @Override
    public Line[] getLines() throws ParseException {
        return this.getTokens() != null ? this.getTokens().getLines() : null;
    }

    public Token[] getIdentifiers() throws ParseException {
        return this.getTokens().getIdentifiers();
    }

    @Override
    public Line getLine(int lineNumber) throws ParseException {
        Line[] lines = this.getLines();
        if (lines == null) {
            return null;
        }
        int zeroIndexedLineNumber = lineNumber - 1;
        if (zeroIndexedLineNumber < 0 || zeroIndexedLineNumber >= lines.length) {
            return null;
        }
        return lines[zeroIndexedLineNumber];
    }

    @Override
    public int getNumberOfLines() throws ParseException {
        return this.getTokens() == null ? 0 : this.getTokens().getLines().length;
    }

    @Override
    public Token getCodeTokenAfter(Token token) throws ParseException {
        return this.getTokens().getCodeTokenAfter(token);
    }

    @Override
    public Token getCodeTokenBefore(Token token) throws ParseException {
        return this.getTokens().getCodeTokenBefore(token);
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public String getShortFileName() {
        int slashIndex = this.filename.lastIndexOf(47);
        if (slashIndex < 0) {
            return this.filename;
        }
        return this.filename.substring(slashIndex + 1);
    }

    public String getPackageName() {
        int slashIndex = this.filename.lastIndexOf(47);
        if (slashIndex < 0) {
            return "(default package)";
        }
        return this.filename.substring(0, slashIndex).replace('/', '.');
    }

    public void linkTokenWithClassname(Token token, QualifiedClassName name) {
        this.classnamesByToken.put(token, name);
    }

    @Override
    public QualifiedClassName getClassnameFor(Token token) {
        return this.classnamesByToken.get(token);
    }

    @Override
    public Parameter getMethodParameterFor(Token token) {
        return this.parametersByToken.get(token);
    }

    public void linkTokenWithParameter(Token token, Parameter parameter) {
        this.parametersByToken.put(token, parameter);
    }

    public void linkTokenWithInstruction(Token token, Instruction instruction) {
        this.instructionsByToken.put(token, instruction);
    }

    public void linkInstructionWithTokenRange(Instruction instruction, Token first, Token last) {
        this.tokensByInstruction.put(instruction, new TokenRange(first, last));
    }

    @Override
    public TokenRange getTokenRangeFor(Instruction instruction) {
        TokenRange range;
        try {
            ClassBodyElement m = this.getTokens().getMethodElement(instruction.getMethod());
            if (m != null) {
                m.parseBlock();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if ((range = this.tokensByInstruction.get(instruction)) == null) {
            return instruction.getLine().getRange();
        }
        return range;
    }

    @Override
    public Instruction getInstructionFor(Token token) {
        try {
            this.getTokens().parseBlocks();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return this.instructionsByToken.get(token);
    }

    public TokenRange getTokenRangeForField(FieldInfo field) {
        try {
            this.getTokens();
        }
        catch (ParseException e) {
            return null;
        }
        if (this.parser != null) {
            ClassBodyElement f = this.parser.getFieldElement(field);
            return f == null ? null : new TokenRange(f.firstToken, f.lastToken);
        }
        return null;
    }

    @Override
    public TokenRange getTokenRangeForMethod(MethodInfo method) {
        try {
            this.getTokens();
        }
        catch (ParseException e) {
            return null;
        }
        TokenRange range = null;
        if (this.parser != null) {
            ClassBodyElement m = this.parser.getMethodElement(method);
            TokenRange tokenRange = range = m == null ? null : m.getTokenRangeOfHeader();
        }
        if (range == null) {
            range = method.getCode().getFirstInstruction().getLine().getRange();
        }
        return range;
    }

    @Override
    public TokenRange getTokenRangeForParameter(MethodInfo method, int parameter) {
        try {
            this.getTokens();
            ClassBodyElement m = this.parser.getMethodElement(method);
            return m == null ? null : m.getTokenRangeForParameter(parameter);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public TokenRange getTokenRangeForReturnType(MethodInfo method) {
        try {
            this.getTokens();
            ClassBodyElement m = this.parser.getMethodElement(method);
            return m == null ? null : m.getTokenRangeForReturnType();
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Override
    public TokenRange getTokenRangeFor(Classfile classfile) {
        try {
            this.getTokens();
            ClassElement c = this.parser.getClassElement(classfile);
            return c == null ? null : c.getHeaderRange();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void linkClassfile(Classfile classfile) {
        this.classfiles.add(classfile);
    }

    public Iterable<Classfile> getClassfiles() {
        return this.classfiles;
    }

    public List<MethodInfo> getMethods() {
        ArrayList<MethodInfo> methods = new ArrayList<MethodInfo>();
        for (Classfile c : this.classfiles) {
            for (MethodInfo method : c.getDeclaredMethods()) {
                methods.add(method);
            }
        }
        return Collections.unmodifiableList(methods);
    }

    public Token getTokenOfArithmetic(Computation inst) {
        Line line = inst.getLine();
        SortedSet<Instruction> instructions = this.getInstructionsOnLine(line);
        List<Token> tokens = line.getTokens();
        int number = 0;
        boolean found = false;
        for (Instruction i : instructions) {
            if (!(i instanceof Computation)) continue;
            if (i == inst) {
                found = true;
                break;
            }
            ++number;
        }
        if (!found) {
            return null;
        }
        int operatorNumber = 0;
        for (Token token : tokens) {
            if (!token.isOperator()) continue;
            if (operatorNumber == number) {
                return token;
            }
            ++operatorNumber;
        }
        return null;
    }

    public Token getTokenOfReturn(AbstractReturn inst) {
        int number;
        List<Token> tokens;
        block8: {
            Line line = inst.getLine();
            SortedSet<Instruction> instructions = this.getInstructionsOnLine(line);
            tokens = line.getTokens();
            number = 0;
            boolean found = false;
            for (Instruction i : instructions) {
                if (!(i instanceof AbstractReturn)) continue;
                if (i == inst) {
                    found = true;
                    break;
                }
                ++number;
            }
            if (found) break block8;
            return null;
        }
        try {
            int returnNumber = 0;
            Token lastToken = null;
            for (Token token : tokens) {
                if (token.kind == 49) {
                    if (returnNumber == number) {
                        return token;
                    }
                    ++returnNumber;
                }
                lastToken = token;
            }
            ClassBodyElement structure = this.getTokens().getMethodElement(inst.getMethod());
            return structure == null ? null : structure.getLastToken();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Token.PairedToken getLeftBracketOfArrayReference(Instruction inst) {
        Line line = inst.getLine();
        SortedSet<Instruction> instructions = this.getInstructionsOnLine(line);
        List<Token> tokens = line.getTokens();
        int number = 0;
        boolean found = false;
        for (Instruction i : instructions) {
            if (!(i instanceof GetArrayValue) && !(i instanceof SetArrayValue)) continue;
            if (i == inst) {
                found = true;
                break;
            }
            ++number;
        }
        if (!found) {
            return null;
        }
        int leftBracketNumber = 0;
        for (Token token : tokens) {
            if (token.kind != 83) continue;
            if (leftBracketNumber == number) {
                return (Token.PairedToken)token;
            }
            ++leftBracketNumber;
        }
        return null;
    }

    public Token getTokenOfConstant(PushConstant<?> inst) {
        Line line = inst.getLine();
        SortedSet<Instruction> instructions = this.getInstructionsOnLine(line);
        List<Token> tokens = line.getTokens();
        int number = 0;
        boolean found = false;
        for (Instruction i : instructions) {
            if (!(i instanceof PushConstant)) continue;
            if (i == inst) {
                found = true;
                break;
            }
            ++number;
        }
        if (!found) {
            return null;
        }
        int constantNumber = 0;
        for (Token token : tokens) {
            if (!token.isLiteral()) continue;
            if (constantNumber == number) {
                return token;
            }
            ++constantNumber;
        }
        return null;
    }

    public Token getFirstTokenOfMethod(MethodInfo method) {
        Token name = this.getTokenForMethodName(method);
        if (name != null) {
            return name.getLine().getFirstCodeToken();
        }
        return null;
    }

    public Token getLastTokenOfMethod(MethodInfo method) {
        try {
            ClassBodyElement m = this.getTokens().getMethodElement(method);
            if (m != null) {
                return m.getLastToken();
            }
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Token getTokenForClassName(Classfile classfile) {
        try {
            ClassElement c = this.getTokens().getClassElement(classfile);
            if (c != null) {
                return c.getNameToken();
            }
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Token getTokenForMethodName(MethodInfo method) {
        try {
            assert (method.getClassfile().getSourceFile() == this) : "But " + this + " isn't the source file for " + method.getQualifiedNameAndDescriptor();
            ClassBodyElement m = this.getTokens().getMethodElement(method);
            return m == null ? null : m.getNameToken();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Token getFirstTokenOfMethodHeader(MethodInfo method) {
        Token token = this.getTokenForMethodName(method);
        if (token == null) {
            return null;
        }
        return token.getLine().getFirstCodeToken();
    }

    public String getMethodJavaDoc(MethodInfo method) {
        try {
            ClassBodyElement methodStructure = this.getTokens().getMethodElement(method);
            return methodStructure == null ? "" : methodStructure.getJavaDoc();
        }
        catch (ParseException e) {
            return null;
        }
    }

    public String getClassJavaDoc(Classfile classfile) {
        block3: {
            try {
                if (this.getTokens() != null) break block3;
                return null;
            }
            catch (ParseException e) {
                return null;
            }
        }
        ClassElement classStructure = this.getTokens().getClassElement(classfile);
        return classStructure == null ? "" : classStructure.getJavaDoc();
    }

    public String getNameOfParameterNumber(MethodInfo method, int number) {
        assert (number > 0 && number <= method.getNumberOfArguments()) : number + " is an illegal argument number for " + method.getDescriptor();
        try {
            Token name;
            ClassBodyElement m = this.getTokens().getMethodElement(method);
            Token token = name = m == null ? null : m.getParameterNameToken(number);
            if (name != null) {
                return name.getText();
            }
            return "arg" + number;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public Token[] getCodeTokens() throws ParseException {
        this.getTokens();
        if (this.parser == null) {
            return null;
        }
        Token[] t = this.parser.getCodeTokens();
        return t == null ? null : t;
    }

    public String getSourceAsString() throws ParseException {
        this.getTokens();
        if (this.parser != null) {
            return this.parser.getString();
        }
        return null;
    }

    @Override
    public SortedSet<Instruction> getInstructionsOnLine(Line line) {
        for (Classfile cf : this.classfiles) {
            SortedSet<Instruction> instructionsOnLine = cf.getInstructionsOnLineNumber(line.getLineNumber());
            if (instructionsOnLine.isEmpty()) continue;
            return instructionsOnLine;
        }
        return new TreeSet<Instruction>();
    }

    public MethodInfo getMethodOfLine(Line line) {
        try {
            SortedSet<Instruction> instructions = this.getInstructionsOnLine(line);
            while (instructions == null || instructions.isEmpty()) {
                if ((line = line.getLineAfter()) == null) break;
                instructions = this.getInstructionsOnLine(line);
            }
            if (instructions != null && !instructions.isEmpty()) {
                Instruction inst = instructions.first();
                if (inst != null) {
                    return inst.getMethod();
                }
                return null;
            }
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getLocalIDNameRelativeToInstruction(int localID, Instruction inst) {
        try {
            List<SetLocal> sets = inst.getCode().getLocalDependencies().getPotentialDefinitionsOfLocalIDBefore(inst, localID);
            for (SetLocal set : sets) {
                for (Token token : set.getLine().getTokens()) {
                    if (token.kind != 89) continue;
                    Token localIdentifier = token.getPreviousCodeToken();
                    if (localIdentifier.kind != 76) continue;
                    return localIdentifier.getText();
                }
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return null;
    }

    public String toString() {
        return this.filename;
    }
}

