/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import edu.cmu.hcii.whyline.source.ClassElement;
import edu.cmu.hcii.whyline.source.FileElement;
import edu.cmu.hcii.whyline.source.JavaParser;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.source.Token;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaElement {
    protected final JavaElement parent;
    protected final Token firstToken;
    protected final Token lastToken;
    private boolean parsed = false;

    public JavaElement(JavaElement parent, Token first, Token last) {
        this.parent = parent;
        assert (first != null);
        assert (last != null);
        this.firstToken = first;
        this.lastToken = last;
    }

    public JavaElement getParent() {
        return this.parent;
    }

    public ClassElement getEnclosingClass() {
        return this.parent == null ? null : this.parent.getEnclosingClass();
    }

    public FileElement getRoot() {
        return this.parent.getRoot();
    }

    public JavaSourceFile getSource() {
        return this.parent.getSource();
    }

    public final Token getFirstToken() {
        return this.firstToken;
    }

    public final Token getLastToken() {
        return this.lastToken;
    }

    public boolean contains(Token t) {
        if (t.getFile() != this.getSource()) {
            return false;
        }
        Line startLine = this.firstToken.getLine();
        Line endLine = this.lastToken.getLine();
        Line givenLine = t.getLine();
        if (startLine.getLineNumber().getNumber() > givenLine.getLineNumber().getNumber()) {
            return false;
        }
        if (endLine.getLineNumber().getNumber() < givenLine.getLineNumber().getNumber()) {
            return false;
        }
        if (givenLine == startLine && this.firstToken.getLineIndex() > t.getLineIndex()) {
            return false;
        }
        return givenLine != endLine || this.lastToken.getLineIndex() >= t.getLineIndex();
    }

    protected JavaParser.TokenIterator getIterator() throws ParseException {
        return this.getSource().getTokenIterator(this.firstToken, this.lastToken);
    }

    public final void parse() {
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        try {
            this.parse(this.getIterator());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    protected abstract void parse(JavaParser.TokenIterator var1) throws ParseException;

    protected List<Token.PairedToken> passAnonymousInnerClassesUntilSemiColon(JavaParser.TokenIterator tokens) throws ParseException {
        LinkedList<Token.PairedToken> openBraces = new LinkedList<Token.PairedToken>();
        Stack<Token> recentNewTokenNotFollowedByBrackets = new Stack<Token>();
        while (tokens.hasNext() && !tokens.nextKindIs(85)) {
            Token next = tokens.getNext();
            switch (next.kind) {
                case 81: {
                    if (recentNewTokenNotFollowedByBrackets == null) break;
                    openBraces.add((Token.PairedToken)next);
                    if (!recentNewTokenNotFollowedByBrackets.isEmpty()) {
                        recentNewTokenNotFollowedByBrackets.pop();
                    }
                    tokens.jumpPast(((Token.PairedToken)next).getAssociatedToken());
                    break;
                }
                case 43: {
                    recentNewTokenNotFollowedByBrackets.push(next);
                    break;
                }
                case 84: {
                    if (recentNewTokenNotFollowedByBrackets.isEmpty()) break;
                    recentNewTokenNotFollowedByBrackets.pop();
                }
            }
        }
        return openBraces;
    }

    protected String type(JavaParser.TokenIterator tokens) throws ParseException {
        StringBuilder type = new StringBuilder();
        if (tokens.nextIsPrimitive()) {
            type.append(tokens.getNext().getText());
        } else {
            Token id = tokens.getNext();
            this.typeArguments(tokens);
            while (tokens.nextKindIs(87)) {
                tokens.getNext();
                id = tokens.getNext();
                this.typeArguments(tokens);
            }
            type.append(id.getText());
        }
        type.insert(0, this.optionalBrackets(tokens));
        return type.toString();
    }

    protected String optionalBrackets(JavaParser.TokenIterator tokens) throws ParseException {
        StringBuilder brackets = new StringBuilder();
        while (tokens.hasNext() && tokens.nextKindIs(83)) {
            tokens.getNext();
            tokens.getNext();
            brackets.append("[");
        }
        return brackets.toString();
    }

    protected void variableInitializer(JavaParser.TokenIterator tokens) throws ParseException {
        if (tokens.nextKindIs(81)) {
            Token.PairedToken open = (Token.PairedToken)tokens.getNext();
            tokens.jumpPast(open.getAssociatedToken());
        } else {
            System.err.println("Not parsing expression starting at " + tokens);
            this.expression(tokens);
        }
    }

    protected void parenthesizedExpression(JavaParser.TokenIterator tokens) throws ParseException {
        Token.PairedToken open = tokens.nextPaired(79);
        tokens.jumpPast(open.getAssociatedToken());
    }

    protected void expression(JavaParser.TokenIterator tokens) {
    }

    protected void optionalModifiers(JavaParser.TokenIterator tokens) throws ParseException {
        while (tokens.hasNext() && (tokens.nextIsModifier() || tokens.nextKindIs(88))) {
            if (tokens.nextKindIs(88)) {
                this.optionalAnnotations(tokens);
                continue;
            }
            tokens.getNext();
        }
    }

    protected void typeArguments(JavaParser.TokenIterator tokens) throws ParseException {
        if (!tokens.nextKindIs(90)) {
            return;
        }
        tokens.getNext();
        int lessThans = 1;
        while (tokens.hasNext() && lessThans > 0) {
            if (!tokens.hasNext()) break;
            Token next = tokens.getNext();
            switch (next.kind) {
                case 126: {
                    --lessThans;
                    break;
                }
                case 90: {
                    ++lessThans;
                }
            }
        }
    }

    protected void optionalAnnotations(JavaParser.TokenIterator tokens) throws ParseException {
        block0: while (tokens.hasNext() && tokens.nextKindIs(88)) {
            tokens.getNext();
            tokens.getNext();
            if (!tokens.nextKindIs(79)) continue;
            Token.PairedToken leftParen = (Token.PairedToken)tokens.getNext();
            while (tokens.hasNext()) {
                if (!tokens.hasNext()) continue block0;
                Token rightParen = tokens.getNext();
                if (leftParen.getAssociatedToken() == rightParen) continue block0;
            }
        }
    }
}

