/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.source;

import edu.cmu.hcii.whyline.bytecode.ARRAYLENGTH;
import edu.cmu.hcii.whyline.bytecode.ATHROW;
import edu.cmu.hcii.whyline.bytecode.AbstractReturn;
import edu.cmu.hcii.whyline.bytecode.BinaryComputation;
import edu.cmu.hcii.whyline.bytecode.Branch;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.ConditionalBranch;
import edu.cmu.hcii.whyline.bytecode.Conversion;
import edu.cmu.hcii.whyline.bytecode.DUP;
import edu.cmu.hcii.whyline.bytecode.GETFIELD;
import edu.cmu.hcii.whyline.bytecode.GETSTATIC;
import edu.cmu.hcii.whyline.bytecode.GetArrayValue;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.IINC;
import edu.cmu.hcii.whyline.bytecode.INSTANCEOF;
import edu.cmu.hcii.whyline.bytecode.INVOKESPECIAL;
import edu.cmu.hcii.whyline.bytecode.Instantiation;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MONITORENTER;
import edu.cmu.hcii.whyline.bytecode.MONITOREXIT;
import edu.cmu.hcii.whyline.bytecode.NEW;
import edu.cmu.hcii.whyline.bytecode.PUTFIELD;
import edu.cmu.hcii.whyline.bytecode.PUTSTATIC;
import edu.cmu.hcii.whyline.bytecode.PushConstant;
import edu.cmu.hcii.whyline.bytecode.SetArrayValue;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.bytecode.TableBranch;
import edu.cmu.hcii.whyline.bytecode.UnaryComputation;
import edu.cmu.hcii.whyline.bytecode.UnconditionalBranch;
import edu.cmu.hcii.whyline.source.ArrayLengthExpression;
import edu.cmu.hcii.whyline.source.BinaryOperatorExpression;
import edu.cmu.hcii.whyline.source.BranchExpression;
import edu.cmu.hcii.whyline.source.CallExpression;
import edu.cmu.hcii.whyline.source.CastExpression;
import edu.cmu.hcii.whyline.source.ConsumerExpression;
import edu.cmu.hcii.whyline.source.Expression;
import edu.cmu.hcii.whyline.source.GetArrayValueExpression;
import edu.cmu.hcii.whyline.source.GetFieldExpression;
import edu.cmu.hcii.whyline.source.GetStaticExpression;
import edu.cmu.hcii.whyline.source.InstanceOfExpression;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.LiteralExpression;
import edu.cmu.hcii.whyline.source.LocalExpression;
import edu.cmu.hcii.whyline.source.MonitorEnterExpression;
import edu.cmu.hcii.whyline.source.MonitorExitExpression;
import edu.cmu.hcii.whyline.source.NewExpression;
import edu.cmu.hcii.whyline.source.PutFieldExpression;
import edu.cmu.hcii.whyline.source.PutStaticExpression;
import edu.cmu.hcii.whyline.source.ReturnExpression;
import edu.cmu.hcii.whyline.source.SetArrayExpression;
import edu.cmu.hcii.whyline.source.SetLocalExpression;
import edu.cmu.hcii.whyline.source.SwitchExpression;
import edu.cmu.hcii.whyline.source.ThrowExpression;
import edu.cmu.hcii.whyline.source.UnaryOperatorExpression;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Decompiler {
    private final JavaSourceFile source;
    private final CodeAttribute code;
    private final Instruction[] instructions;
    private List<ConsumerExpression<?>> consumers = new ArrayList(10);
    private Map<Instruction, Expression<?>> expressions = new HashMap();

    public Decompiler(JavaSourceFile source, CodeAttribute code) {
        this.source = source;
        this.code = code;
        this.instructions = code.getInstructions();
        this.analyze();
    }

    public JavaSourceFile getSource() {
        return this.source;
    }

    public ConsumerExpression<?> peekConsumer() {
        return this.consumers.isEmpty() ? null : this.consumers.get(0);
    }

    public ConsumerExpression<?> consume() {
        return this.consumers.isEmpty() ? null : this.consumers.remove(0);
    }

    private void analyze() {
        TreeSet cons = new TreeSet(new Comparator<ConsumerExpression<?>>(){

            @Override
            public int compare(ConsumerExpression<?> o1, ConsumerExpression<?> o2) {
                int line2;
                int line1 = o1.getCode().getLineNumber().getNumber();
                if (line1 != (line2 = o2.getCode().getLineNumber().getNumber())) {
                    return line1 - line2;
                }
                return o1.getCode().getIndex() - o2.getCode().getIndex();
            }
        });
        LinkedList forLoopConditions = new LinkedList();
        Instruction[] instructionArray = this.instructions;
        int n = this.instructions.length;
        int n2 = 0;
        while (n2 < n) {
            Instruction inst = instructionArray[n2];
            if (inst.getConsumers().getNumberOfConsumers() == 0 && (inst.getNumberOfOperandsConsumed() > 0 || inst instanceof Invoke || inst instanceof IINC)) {
                ConsumerExpression<?> consumer;
                boolean isConsumedNEW = inst instanceof NEW && inst.getConsumers().getNumberOfConsumers() > 0;
                boolean isInstanceInitialization = inst instanceof INVOKESPECIAL;
                if (!isConsumedNEW && !isInstanceInitialization && (consumer = this.toConsumerExpression(inst)) != null) {
                    cons.add(consumer);
                }
            }
            ++n2;
        }
        this.consumers = new LinkedList(cons);
        int i = 0;
        while (i < this.consumers.size()) {
            ConsumerExpression<?> consumer = this.consumers.get(i);
            if (consumer.getCode() instanceof ConditionalBranch && ((ConditionalBranch)consumer.getCode()).isForLoop()) {
                UnconditionalBranch unconditional = consumer.getCode().getUnconditionalBranchPrecessessor();
                int initIndex = 0;
                Instruction init = unconditional.getPrevious();
                ConsumerExpression<?> initExpression = null;
                for (ConsumerExpression<?> c : this.consumers) {
                    if (c.getCode() == init) {
                        initExpression = c;
                        break;
                    }
                    ++initIndex;
                }
                Instruction advance = unconditional.getTarget().getPrevious();
                ConsumerExpression<?> advanceExpression = null;
                for (ConsumerExpression<?> c : this.consumers) {
                    if (c.getCode() != advance) continue;
                    advanceExpression = c;
                    break;
                }
                if (initExpression != null && advanceExpression != null) {
                    int conditionIndex = this.consumers.indexOf(consumer);
                    this.consumers.remove(conditionIndex);
                    this.consumers.add(Math.min(initIndex + 1, this.consumers.size()), consumer);
                    int advanceIndex = this.consumers.indexOf(advanceExpression);
                    this.consumers.remove(advanceIndex);
                    this.consumers.add(Math.min(initIndex + 2, this.consumers.size()), advanceExpression);
                }
            }
            ++i;
        }
    }

    public Expression<?> getExpression(Instruction consumer, Instruction producer) {
        if (producer == null) {
            return null;
        }
        Expression<?> expr = this.expressions.get(producer);
        if (expr == null) {
            expr = this.toExpression(consumer, producer);
            this.expressions.put(producer, expr);
        }
        return expr;
    }

    private Expression<?> toExpression(Instruction consumer, Instruction producer) {
        int opcode = producer.getOpcode();
        switch (opcode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return new LiteralExpression(this, (PushConstant)producer);
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return new LocalExpression(this, (GetLocal)producer);
            }
            case 180: {
                return new GetFieldExpression(this, (GETFIELD)producer);
            }
            case 178: {
                return new GetStaticExpression(this, (GETSTATIC)producer);
            }
            case 190: {
                return new ArrayLengthExpression(this, (ARRAYLENGTH)producer);
            }
            case 192: {
                break;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                return new CastExpression(this, (Conversion)producer);
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return new GetArrayValueExpression(this, (GetArrayValue)producer);
            }
            case 188: 
            case 189: 
            case 197: {
                return new NewExpression(this, (Instantiation)producer);
            }
            case 187: {
                if (consumer instanceof INVOKESPECIAL) {
                    return new NewExpression(this, (Instantiation)producer);
                }
                if (producer.getNext() instanceof DUP) {
                    Instruction c = producer.getNext();
                    while (c != null && !(c instanceof INVOKESPECIAL)) {
                        c = c.getConsumers().getFirstConsumer();
                    }
                    return consumer == null ? new NewExpression(this, (Instantiation)producer) : this.getExpression(consumer, c);
                }
                return new NewExpression(this, (Instantiation)producer);
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                return new CallExpression(this, (Invoke)producer);
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return new BinaryOperatorExpression(this, (BinaryComputation)producer);
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                return new UnaryOperatorExpression(this, (UnaryComputation)producer);
            }
            case 193: {
                return new InstanceOfExpression(this, (INSTANCEOF)producer);
            }
            case 89: 
            case 90: 
            case 91: {
                StackDependencies.Producers producers = producer.getProducersOfArgument(0);
                Expression<?> expr = this.getExpression(consumer, producers.getFirstProducer());
                return expr;
            }
            case 92: 
            case 93: 
            case 94: {
                System.err.println("Not handling dup2lications");
                break;
            }
            default: {
                assert (false) : "Shouldn't be creating an expression for " + producer;
                break;
            }
        }
        return null;
    }

    private ConsumerExpression<?> toConsumerExpression(Instruction consumer) {
        int opcode = consumer.getOpcode();
        switch (opcode) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                return new CallExpression(this, (Invoke)consumer);
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 132: {
                return new SetLocalExpression(this, (SetLocal)consumer);
            }
            case 179: {
                return new PutStaticExpression(this, (PUTSTATIC)consumer);
            }
            case 181: {
                return new PutFieldExpression(this, (PUTFIELD)consumer);
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 198: 
            case 199: 
            case 200: {
                return new BranchExpression(this, (Branch)consumer);
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                return new ReturnExpression(this, (AbstractReturn)consumer);
            }
            case 51: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return new SetArrayExpression(this, (SetArrayValue)consumer);
            }
            case 191: {
                return new ThrowExpression(this, (ATHROW)consumer);
            }
            case 170: 
            case 171: {
                return new SwitchExpression(this, (TableBranch)consumer);
            }
            case 194: {
                return new MonitorEnterExpression(this, (MONITORENTER)consumer);
            }
            case 195: {
                return new MonitorExitExpression(this, (MONITOREXIT)consumer);
            }
        }
        return null;
    }

    public int getExpressionsRemaining() {
        return this.expressions.size();
    }
}

