/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.analysis.UnexecutedInstructionAnalyzer;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.Instantiation;
import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.Asker;
import edu.cmu.hcii.whyline.qa.CauseAnswer;
import edu.cmu.hcii.whyline.qa.MessageAnswer;
import edu.cmu.hcii.whyline.qa.WhyDidntQuestion;
import edu.cmu.hcii.whyline.util.IntegerVector;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WhyDidntWindowAppear
extends WhyDidntQuestion<Classfile> {
    public WhyDidntWindowAppear(Asker asker, Classfile windowType, String descriptionOfEvent) {
        super(asker, windowType, descriptionOfEvent);
    }

    @Override
    protected Answer answer() {
        if (this.scope.isEndOfProgram()) {
            return new MessageAnswer(this, "<i>Nothing</i> changed after the end of the program. Perhaps you forgot to select a specific time?");
        }
        IntegerVector instantationIDs = this.trace.getInstantiationHistory().getInstantiationsOf((Classfile)this.subject);
        boolean instantiationsExecuted = instantationIDs.size() > 0;
        int i = 0;
        while (i < instantationIDs.size()) {
            int instantiationID = instantationIDs.get(i);
            if (this.scope.includesInclusive(instantiationID)) {
                return new CauseAnswer(this, instantiationID, "An instance of <b>" + ((Classfile)this.subject).getDisplayName(false, -1) + "</b> was created. Maybe it <b>setVisible</b>() wasn't called?");
            }
            ++i;
        }
        if (instantiationsExecuted) {
            return new CauseAnswer(this, instantationIDs.lastValue(), "There were instantiations of <b>" + ((Classfile)this.subject).getDisplayName(false, -1) + "</b>, but not after the input you selected. Here is the most recent.");
        }
        List<Instantiation> instantiations = this.trace.getInstantiationsOf(((Classfile)this.subject).getInternalName());
        if (instantiations.isEmpty()) {
            return new MessageAnswer(this, "There are no known instantiations of <b>" + ((Classfile)this.subject).getDisplayName(false, -1) + "</b> in this program.");
        }
        return UnexecutedInstructionAnalyzer.explain(this, instantiations.toArray(new Instantiation[instantiations.size()]), null);
    }

    @Override
    public String getQuestionExplanation() {
        return "explain why windows of type <b>" + this.getDescriptionOfSubject() + "</b> didn't appear";
    }
}

