/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.analysis.UnexecutedInstructionAnalyzer;
import edu.cmu.hcii.whyline.bytecode.Definition;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.Asker;
import edu.cmu.hcii.whyline.qa.ExpectedObject;
import edu.cmu.hcii.whyline.qa.MessageAnswer;
import edu.cmu.hcii.whyline.qa.UnexecutedAnswer;
import edu.cmu.hcii.whyline.qa.WhyDidntQuestion;
import edu.cmu.hcii.whyline.trace.Value;
import edu.cmu.hcii.whyline.trace.nodes.ObjectState;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhyDidntFieldChange
extends WhyDidntQuestion<FieldInfo> {
    private final long objectID;

    public WhyDidntFieldChange(Asker asker, ObjectState object, FieldInfo field, Value value, String event) {
        super(asker, field, event);
        this.objectID = object.getObjectID();
    }

    @Override
    protected Answer answer() throws AnalysisException {
        if (this.scope.isEndOfProgram()) {
            return new MessageAnswer(this, "<i>Nothing</i> changed after the end of the program. Perhaps you forgot to select a specific time?");
        }
        this.asker.processing(true);
        ArrayList<Definition> assignments = new ArrayList<Definition>();
        for (Definition assignment : ((FieldInfo)this.subject).getDefinitions()) {
            if (assignment.getMethod().isInstanceInitializer()) continue;
            assignments.add(assignment);
        }
        UnexecutedAnswer answer = UnexecutedInstructionAnalyzer.explain(this, assignments.toArray(new Definition[assignments.size()]), new ExpectedObject(this.objectID, 0));
        this.asker.processing(false);
        return answer;
    }

    @Override
    public String getQuestionExplanation() {
        return "explain why " + ((FieldInfo)this.subject).getDisplayName(true, -1) + " didn't change after " + this.scope.getDescription();
    }
}

