/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.qa.UnexecutedInstruction;
import edu.cmu.hcii.whyline.util.IntegerVector;
import gnu.trove.TIntHashSet;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnexecutedAnswer
extends Answer {
    private final TIntHashSet decidingEvents = new TIntHashSet();

    public UnexecutedAnswer(Question<?> question, UnexecutedInstruction[] unexecutedInstructions) {
        super(question, unexecutedInstructions);
        UnexecutedInstruction[] unexecutedInstructionArray = unexecutedInstructions;
        int n = unexecutedInstructions.length;
        int n2 = 0;
        while (n2 < n) {
            UnexecutedInstruction unexecuted = unexecutedInstructionArray[n2];
            this.finishExplainingDecisionPoints(new HashSet<UnexecutedInstruction>(), unexecuted);
            ++n2;
        }
    }

    public void finishExplainingDecisionPoints(Set<UnexecutedInstruction> visited, UnexecutedInstruction inst) {
        if (visited.contains(inst)) {
            return;
        }
        visited.add(inst);
        if (inst.getDecidingEventID() >= 0) {
            this.decidingEvents.add(inst.getDecidingEventID());
            this.getExplanationFor(inst.getDecidingEventID()).explain();
        }
        if (inst.getDecidingEvents() != null) {
            IntegerVector events = inst.getDecidingEvents();
            int i = 0;
            while (i < events.size()) {
                int eventID = events.get(i);
                this.decidingEvents.add(eventID);
                this.getExplanationFor(eventID).explain();
                ++i;
            }
        }
        for (UnexecutedInstruction in : inst.getIncoming()) {
            this.finishExplainingDecisionPoints(visited, in);
        }
    }

    public boolean isDecidedBy(int eventID) {
        return this.decidingEvents.contains(eventID);
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public String getAnswerText() {
        return "Check the answer below.";
    }

    @Override
    public String getKind() {
        return "Certain instructions didn't execute...";
    }
}

