/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.qa.Asker;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.qa.QuestionMenuMaker;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.ui.components.WhylineMenu;
import edu.cmu.hcii.whyline.ui.components.WhylineMenuItem;
import edu.cmu.hcii.whyline.ui.components.WhylinePopup;
import edu.cmu.hcii.whyline.ui.events.AbstractUIEvent;
import edu.cmu.hcii.whyline.ui.events.LoggedAction;
import edu.cmu.hcii.whyline.util.Named;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuestionMenu
implements Comparable<QuestionMenu> {
    private final ArrayList<Object> items = new ArrayList();
    private final Asker asker;
    private final String description;
    private String label;
    private final Named subject;
    private QuestionMenu parent = null;
    public static int MENU_ITEM_HEIGHT = 0;
    private static boolean makerMaking = false;
    private static Object waiter = new Integer(0);

    public QuestionMenu(Asker asker, String description, String label, Named subject) {
        String displayName;
        this.asker = asker;
        this.subject = subject;
        String string = displayName = subject == null ? null : subject.getDisplayName(true, -1);
        if (subject != null) {
            label = label.replace("%", displayName);
        }
        this.label = label;
        if (subject != null) {
            description = description.replace("%", displayName);
        }
        this.description = description;
    }

    public QuestionMenu(Asker asker, String description, String label) {
        this(asker, description, label, null);
    }

    public Asker getAsker() {
        return this.asker;
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMenuLabel() {
        return this.label;
    }

    public Named getSubject() {
        return this.subject;
    }

    public int getNumberOfItems() {
        return this.items.size();
    }

    public Iterable<Object> getItems() {
        return this.items;
    }

    public void addQuestion(Question<?> question) {
        this.items.add(question);
    }

    public void insertQuestion(Question<?> question) {
        this.items.add(0, question);
    }

    public void insertSeparator() {
        this.items.add(0, null);
    }

    public void addItemsOf(QuestionMenu menu) {
        this.items.addAll(menu.items);
    }

    public void addMenu(QuestionMenu menu) {
        assert (menu != this) : "Can't add menu to itself.";
        assert (menu.parent == null) : this + " is already in " + this.parent;
        this.items.add(menu);
        menu.parent = this;
    }

    public void addMaker(QuestionMenuMaker maker) {
        this.items.add(maker);
    }

    public void addSeparator() {
        this.items.add(null);
    }

    public void addMessage(String message) {
        this.items.add(message);
    }

    public WhylinePopup generatePopupMenu() {
        if (MENU_ITEM_HEIGHT <= 0) {
            MENU_ITEM_HEIGHT = new MessageItem(null, (String)"Get me the height!").getPreferredSize().height;
        }
        WhylinePopup menu = new WhylinePopup(this.getMenuLabel());
        for (Object item : this.items) {
            if (item == null) {
                menu.addSeparator();
                continue;
            }
            if (item instanceof QuestionMenu) {
                if (((QuestionMenu)item).getNumberOfItems() <= 0) continue;
                menu.add(((QuestionMenu)item).generateMenu());
                continue;
            }
            if (item instanceof Question) {
                menu.add(new QuestionItem((Question)item, this));
                continue;
            }
            if (item instanceof String) {
                menu.add(new MessageItem(null, (String)item));
                continue;
            }
            throw new RuntimeException("Not adding " + item + "of type " + item.getClass());
        }
        menu.setFont(UI.getMediumFont());
        return menu;
    }

    public Menu generateMenu() {
        Menu menu = new Menu(this.getMenuLabel(), this);
        return menu;
    }

    @Override
    public int compareTo(QuestionMenu menu) {
        return this.getMenuLabel().compareTo(menu.getMenuLabel());
    }

    public String toString() {
        return "questions about \"" + this.subject.getDisplayName(false, -1) + "\"";
    }

    public static class MakerMenu
    extends Menu {
        private final Asker asker;
        private final QuestionMenuMaker maker;
        private boolean addedNote = false;
        private Thread makerThread;

        public MakerMenu(Asker asker, QuestionMenuMaker maker) {
            super(maker.getMenuLabel(), (QuestionMenu)null);
            this.asker = asker;
            this.maker = maker;
            this.add(new MessageItem(this, "hover to gather questions..."));
        }

        public String getDescription() {
            return this.menu == null ? "Questions about (still making menu...)" : this.menu.description;
        }

        public Named getSubject() {
            return this.maker.getSubject();
        }

        public void addItemsIfNecessary(boolean itemSelected) {
            if (this.menu != null) {
                super.addItemsIfNecessary(true);
                return;
            }
            if (itemSelected) {
                if (!this.addedNote) {
                    this.removeAll();
                    this.add(new MessageItem(this, "gathering questions..."));
                    this.addedNote = true;
                }
                if (this.maker.wasCanceled()) {
                    this.maker.uncancel();
                }
                this.makerThread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = waiter;
                        synchronized (object) {
                            MakerMenu.this.asker.processing(true);
                            makerMaking = true;
                            MakerMenu.this.menu = MakerMenu.this.maker.make();
                            makerMaking = false;
                            if (MakerMenu.this.maker.wasCanceled()) {
                                MakerMenu.this.menu = null;
                            } else {
                                if (MakerMenu.this.menu.getNumberOfItems() == 0) {
                                    MakerMenu.this.menu.addMessage("no questions");
                                }
                                MakerMenu.this.addItemsIfNecessary(true);
                            }
                            waiter.notifyAll();
                            MakerMenu.this.asker.processing(false);
                        }
                    }
                };
                this.makerThread.start();
            }
        }

        public void cancel() {
            if (this.menu == null && this.makerThread != null) {
                this.maker.cancel();
            }
        }

        public String toString() {
            return "maker menu for " + this.getSubject();
        }
    }

    public static class Menu
    extends WhylineMenu {
        protected QuestionMenu menu;
        private boolean itemsAdded = false;

        public Menu(String name, QuestionMenu menu) {
            super("<html>" + name + "</html>");
            this.menu = menu;
            this.setFont(UI.getMediumFont());
            if (menu != null) {
                this.setToolTipText("<html>" + menu.getDescription());
            }
        }

        public String getDescription() {
            return this.menu.getDescription();
        }

        public Named getSubject() {
            return this.menu.getSubject();
        }

        public void addItemsIfNecessary(boolean make) {
            if (this.itemsAdded) {
                return;
            }
            this.itemsAdded = true;
            this.removeAll();
            int maxHeight = 800;
            int totalHeight = 0;
            WhylineMenu menuToAddTo = this;
            for (Object item : this.menu.getItems()) {
                if ((totalHeight += MENU_ITEM_HEIGHT) > maxHeight - MENU_ITEM_HEIGHT) {
                    menuToAddTo = new MoreMenu();
                    this.add(menuToAddTo);
                    totalHeight = 0;
                }
                if (item == null) {
                    this.addSeparator();
                    continue;
                }
                if (item instanceof QuestionMenu) {
                    if (((QuestionMenu)item).getNumberOfItems() <= 0) continue;
                    menuToAddTo.add(((QuestionMenu)item).generateMenu());
                    continue;
                }
                if (item instanceof Question) {
                    menuToAddTo.add(new QuestionItem((Question)item, this.menu));
                    continue;
                }
                if (item instanceof String) {
                    menuToAddTo.add(new MessageItem(this, (String)item));
                    continue;
                }
                if (item instanceof QuestionMenuMaker) {
                    menuToAddTo.add(new MakerMenu(this.menu.getAsker(), (QuestionMenuMaker)item));
                    continue;
                }
                throw new RuntimeException("Not adding " + item + "!");
            }
            this.validate();
            this.repaint();
            if (this.getPopupMenu().isShowing()) {
                this.getPopupMenu().setVisible(false);
                this.getPopupMenu().setVisible(true);
            }
        }
    }

    public static class MessageItem
    extends WhylineMenuItem {
        private final Menu menu;

        public MessageItem(Menu menu, String message) {
            super("<html><i>" + message + "</i></html>");
            this.menu = menu;
            this.setEnabled(false);
            this.setOpaque(true);
        }

        public Menu getParentMenu() {
            return this.menu;
        }
    }

    public static class MoreMenu
    extends WhylineMenu {
        public MoreMenu() {
            super("");
            this.setText("<html><i>more...</i></html>");
            this.setFont(UI.getMediumFont());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QuestionItem
    extends WhylineMenuItem {
        private final QuestionMenu menu;
        private final Question<?> question;

        public QuestionItem(Question<?> q, QuestionMenu menu) {
            super("");
            this.menu = menu;
            this.question = q;
            this.setText("<html>" + q.getQuestionText());
            this.addActionListener(new LoggedAction((WhylineUI)this.question.asker){

                @Override
                protected AbstractUIEvent<?> act() {
                    ((QuestionItem)QuestionItem.this).question.asker.answer(QuestionItem.this.question);
                    return null;
                }
            });
            this.setToolTipText("<html>" + q.getQuestionExplanation());
        }

        public Object getSubject() {
            return this.question.getSubject();
        }

        public Question<?> getQuestion() {
            return this.question;
        }
    }
}

