/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.BranchBlock;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.qa.ExplanationBlock;
import java.util.Vector;

public final class LoopBlock
extends ExplanationBlock {
    private final Vector<LoopPathPatternSequence> pathPatterns = new Vector();

    public LoopBlock(Answer answer, int eventID) {
        super(answer, eventID);
    }

    protected void handleNewEvent(Explanation newEvent) {
        this.pathPatterns.removeAllElements();
        BranchBlock startOfSequence = null;
        BranchBlock previousBranchBlock = null;
        for (Explanation event : this.events) {
            if (!(event instanceof BranchBlock)) continue;
            if (startOfSequence == null) {
                startOfSequence = (BranchBlock)event;
            } else if (startOfSequence.getLoopPath() != ((BranchBlock)event).getLoopPath()) {
                this.pathPatterns.add(new LoopPathPatternSequence(startOfSequence, previousBranchBlock));
                startOfSequence = (BranchBlock)event;
            }
            previousBranchBlock = (BranchBlock)event;
        }
        if (startOfSequence != null) {
            this.pathPatterns.add(new LoopPathPatternSequence(startOfSequence, previousBranchBlock));
        }
    }

    public boolean isBranchBlockRedundant(BranchBlock branchBlock) {
        for (LoopPathPatternSequence sequence : this.pathPatterns) {
            if (!sequence.containsBlockButNotFirst(branchBlock)) continue;
            return true;
        }
        return false;
    }

    private final class LoopPathPatternSequence {
        public BranchBlock first;
        public BranchBlock last;

        public LoopPathPatternSequence(BranchBlock first, BranchBlock last) {
            this.first = first;
            this.last = last;
        }

        public boolean containsBlockButNotFirst(BranchBlock branchBlock) {
            return branchBlock.getBlock() == LoopBlock.this && branchBlock != this.first && branchBlock.getEventID() <= this.last.getEventID();
        }
    }
}

