/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.qa.Answer;
import edu.cmu.hcii.whyline.qa.CauseAnswer;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.qa.ThisCodeDidExecuteAnswer;
import edu.cmu.hcii.whyline.qa.ThreadBlock;
import edu.cmu.hcii.whyline.qa.UnexecutedAnswer;
import edu.cmu.hcii.whyline.trace.EventKind;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExplanationBlock
extends Explanation {
    protected final SortedSet<Explanation> events = new TreeSet<Explanation>();

    public ExplanationBlock(Answer answer, int eventID) {
        super(answer, eventID);
    }

    protected final void addExplanation(Explanation explanation) {
        if (!this.shouldAddEvent(explanation)) {
            return;
        }
        assert (this.getEventID() <= explanation.getEventID()) : "Can't add an event that occurred before this block's event:";
        if (explanation instanceof ExplanationBlock) {
            this.getThreadBlock().updateMaxDepth((ExplanationBlock)explanation);
        }
        if (this.events.add(explanation)) {
            this.handleNewEvent(explanation);
            this.answer.eventBlockChanged(this);
        }
    }

    public ThreadBlock getThreadBlock() {
        ExplanationBlock block = this.getBlock();
        while (block != null && !(block instanceof ThreadBlock)) {
            block = block.getBlock();
        }
        return (ThreadBlock)block;
    }

    protected boolean shouldAddEvent(Explanation explanation) {
        EventKind kind = this.answer.trace.getKind(explanation.getEventID());
        if (kind.isValueProduced) {
            if (kind.isInstantiation) {
                return true;
            }
            if (this.answer.trace.getInstruction(explanation.getEventID()).isIO()) {
                return true;
            }
            if (this.answer.getQuestion().getSubject() instanceof Integer && explanation.getEventID() == ((Integer)this.answer.getQuestion().getSubject()).intValue()) {
                return true;
            }
            if (this.answer instanceof CauseAnswer && ((CauseAnswer)this.answer).getEventID() == explanation.getEventID()) {
                return true;
            }
            if (this.answer instanceof ThisCodeDidExecuteAnswer && ((ThisCodeDidExecuteAnswer)this.answer).containsEventID(explanation.getEventID())) {
                return true;
            }
            if (this.answer instanceof UnexecutedAnswer) {
                return ((UnexecutedAnswer)this.answer).isDecidedBy(explanation.getEventID());
            }
            return explanation.isCauseless();
        }
        return true;
    }

    protected void handleNewEvent(Explanation event) {
    }

    public SortedSet<Explanation> getEvents() {
        return Collections.unmodifiableSortedSet(this.events);
    }

    public Explanation getLastEvent() {
        return this.events.isEmpty() ? null : this.events.last();
    }
}

