/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.qa;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.qa.AnswerChangeListener;
import edu.cmu.hcii.whyline.qa.BranchBlock;
import edu.cmu.hcii.whyline.qa.ExceptionBlock;
import edu.cmu.hcii.whyline.qa.Explanation;
import edu.cmu.hcii.whyline.qa.ExplanationBlock;
import edu.cmu.hcii.whyline.qa.InvocationBlock;
import edu.cmu.hcii.whyline.qa.LoopBlock;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.qa.StartMethodBlock;
import edu.cmu.hcii.whyline.qa.ThreadBlock;
import edu.cmu.hcii.whyline.qa.UnexecutedInstruction;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.Trace;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Answer
implements Comparable<Answer> {
    private static int answerID = 0;
    private final int id = answerID++;
    protected final Trace trace;
    protected final Question<?> question;
    private final UnexecutedInstruction[] instructionNotExecuted;
    private final TIntObjectHashMap<Explanation> eventExplanations = new TIntObjectHashMap();
    private final TIntObjectHashMap<ExplanationBlock> blocksRepresentingEvents = new TIntObjectHashMap();
    private final SortedMap<Integer, ThreadBlock> threadBlocks = new TreeMap<Integer, ThreadBlock>();
    private final TIntObjectHashMap<LoopBlock> loopBlocksByFirstBranch = new TIntObjectHashMap();
    private final ArrayList<AnswerChangeListener> listeners = new ArrayList();
    private int latestEventID = -1;
    private String explanation;
    private HashSet<ExplanationBlock> blocksThatChanged = new HashSet();

    public Answer(Question<?> question) {
        this(question, null);
    }

    public Answer(Question<?> question, UnexecutedInstruction[] unexecuted) {
        this.question = question;
        this.trace = question.getTrace();
        this.instructionNotExecuted = unexecuted == null ? new UnexecutedInstruction[]{} : unexecuted;
    }

    public Trace getTrace() {
        return this.trace;
    }

    public UnexecutedInstruction[] getUnexecutedInstructions() {
        return this.instructionNotExecuted;
    }

    public boolean hasVisualizationContent() {
        return this.latestEventID >= 0 || this.instructionNotExecuted != null;
    }

    public abstract String getAnswerText();

    public abstract String getKind();

    protected abstract int getPriority();

    public final void addChangeListener(AnswerChangeListener listener) {
        this.listeners.add(listener);
    }

    public Collection<ThreadBlock> getThreadBlocks() {
        return Collections.unmodifiableCollection(this.threadBlocks.values());
    }

    private ThreadBlock getThreadBlockFor(int threadID) {
        ThreadBlock threadBlock = (ThreadBlock)this.threadBlocks.get(threadID);
        if (threadBlock == null) {
            threadBlock = new ThreadBlock(this, threadID);
            this.threadBlocks.put(threadID, threadBlock);
            for (AnswerChangeListener listener : this.listeners) {
                listener.threadBlockAdded(threadBlock);
            }
        }
        return threadBlock;
    }

    public final boolean hasExplanationFor(int eventID) {
        return this.eventExplanations.containsKey(eventID);
    }

    public final Explanation getExplanationFor(int eventID) {
        if (eventID < 0) {
            return null;
        }
        Explanation explanation = this.eventExplanations.get(eventID);
        if (explanation == null) {
            EventKind kind = this.trace.getKind(eventID);
            explanation = kind.isInvocation ? new InvocationBlock(this, eventID) : (kind.isBranch ? new BranchBlock(this, eventID) : (kind == EventKind.EXCEPTION_THROWN ? new ExceptionBlock(this, eventID) : (kind == EventKind.START_METHOD ? new StartMethodBlock(this, eventID) : new Explanation(this, eventID))));
            this.eventExplanations.put(eventID, explanation);
            if (this.latestEventID < eventID) {
                this.latestEventID = eventID;
            }
        }
        return explanation;
    }

    public int getLatestEventID() {
        return this.latestEventID;
    }

    public ExplanationBlock getBlockRepresentingControlDependencyOf(Explanation explanation) {
        if (explanation.getEventID() < 0) {
            return null;
        }
        if (explanation instanceof ThreadBlock) {
            return null;
        }
        int threadID = this.trace.getThreadID(explanation.getEventID());
        int controlID = this.trace.getControlID(explanation.getEventID());
        if (controlID < 0) {
            ThreadBlock block = this.getThreadBlockFor(threadID);
            assert (block.getThreadID() == threadID) : "threadID = " + threadID + " but found threadID = " + block.getThreadID();
            return block;
        }
        Instruction inst = this.trace.getInstruction(explanation.getEventID());
        Instruction controlInst = this.trace.getInstruction(controlID);
        if (this.trace.getKind((int)controlID).isBranch && controlInst.getMethod() == inst.getMethod() && controlInst.getIndex() > inst.getIndex()) {
            int firstBranchEventID = this.trace.getBranchFirstExecutionInMethod(controlID);
            LoopBlock loopBlock = this.loopBlocksByFirstBranch.get(firstBranchEventID);
            if (loopBlock == null) {
                loopBlock = new LoopBlock(this, firstBranchEventID);
                this.loopBlocksByFirstBranch.put(firstBranchEventID, loopBlock);
            }
            return loopBlock;
        }
        ExplanationBlock block = this.blocksRepresentingEvents.get(controlID);
        if (block == null) {
            Explanation controlExplanation = this.getExplanationFor(controlID);
            assert (controlExplanation instanceof ExplanationBlock) : "Why was the control dependency explanation of \n\n\t" + explanation + "\n\nequal to \n\n\t" + controlExplanation + "\n\n";
            block = (ExplanationBlock)controlExplanation;
            this.blocksRepresentingEvents.put(controlID, block);
        }
        if (this.trace.getThreadID(controlID) != threadID) {
            return this.getThreadBlockFor(threadID);
        }
        return block;
    }

    public Question<?> getQuestion() {
        return this.question;
    }

    public void eventBlockChanged(ExplanationBlock block) {
        this.blocksThatChanged.add(block);
    }

    public void broadcastChanges() {
        if (this.blocksThatChanged.isEmpty()) {
            return;
        }
        for (AnswerChangeListener listener : this.listeners) {
            listener.eventBlocksChanged(Collections.unmodifiableSet(new HashSet<ExplanationBlock>(this.blocksThatChanged)));
        }
        this.blocksThatChanged.clear();
    }

    public final SortedMap<Explanation, Explanation> getTerminalDataDependencies(Explanation explanation) {
        this.getQuestion().getAsker().processing(true);
        TreeMap<Explanation, Explanation> dependencies = new TreeMap<Explanation, Explanation>();
        this.determineTerminalDataDependencies(explanation, dependencies);
        this.getQuestion().getAsker().processing(false);
        return dependencies;
    }

    public final Explanation getSourceOfExplanationsValue(Explanation desiredEvent) {
        int sourceOfValueID = this.trace.getSourceOfValueID(desiredEvent.getEventID());
        this.getTerminalDataDependencies(desiredEvent);
        Explanation source = this.getExplanationFor(sourceOfValueID);
        this.broadcastChanges();
        return source;
    }

    private boolean determineTerminalDataDependencies(Explanation effect, SortedMap<Explanation, Explanation> dependencies) {
        Explanation[] causes = effect.getCauses();
        if (causes == null) {
            return false;
        }
        if (causes.length == 0) {
            return false;
        }
        Explanation[] explanationArray = causes;
        int n = causes.length;
        int n2 = 0;
        while (n2 < n) {
            Explanation cause = explanationArray[n2];
            if (cause != null) {
                assert (effect != cause) : "How can " + this.trace.eventToString(effect.getEventID()) + " explain itself?";
                cause.explain();
                if (this.trace.getKind((int)cause.getEventID()).isValueProduced) {
                    boolean hasCauses = this.determineTerminalDataDependencies(cause, dependencies);
                    if (!hasCauses) {
                        dependencies.put(cause, effect);
                    }
                } else if (cause.isTerminalDataDependency()) {
                    dependencies.put(cause, effect);
                }
            }
            ++n2;
        }
        return true;
    }

    @Override
    public int compareTo(Answer otherAnswer) {
        int priorityDelta = this.getPriority() - otherAnswer.getPriority();
        if (priorityDelta == 0) {
            return this.id - otherAnswer.id;
        }
        return priorityDelta;
    }

    public String toString() {
        return this.getAnswerText();
    }
}

