/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.io.CreateGraphicsOutputEvent;
import edu.cmu.hcii.whyline.io.DrawImageEvent;
import edu.cmu.hcii.whyline.io.GetGraphicsOutputEvent;
import edu.cmu.hcii.whyline.io.GraphicalEventAppearance;
import edu.cmu.hcii.whyline.io.GraphicalOutputEvent;
import edu.cmu.hcii.whyline.io.ModifyClipEvent;
import edu.cmu.hcii.whyline.io.ModifyTransformEvent;
import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.io.SetBackgroundEvent;
import edu.cmu.hcii.whyline.io.SetCompositeEvent;
import edu.cmu.hcii.whyline.io.SetFontEvent;
import edu.cmu.hcii.whyline.io.SetPaintEvent;
import edu.cmu.hcii.whyline.io.SetStrokeEvent;
import edu.cmu.hcii.whyline.io.WindowParser;
import edu.cmu.hcii.whyline.ui.UI;
import edu.cmu.hcii.whyline.ui.io.GraphicsContext;
import gnu.trove.TLongLongHashMap;
import gnu.trove.TLongObjectHashMap;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WindowState {
    private final WindowParser parser;
    private final ArrayList<Repaint> repaints = new ArrayList(1000);
    private BufferedImage image;
    private final TLongObjectHashMap<GraphicsContext> contextsByContextIDs = new TLongObjectHashMap(10000, 0.75f);
    private final TLongObjectHashMap<Image> imagesByImageID = new TLongObjectHashMap(20);
    private final TLongLongHashMap imageIDByContextID = new TLongLongHashMap(20);
    private final TLongObjectHashMap<List<DrawImageEvent>> drawImageEventByImageID = new TLongObjectHashMap(20);
    private Graphics2D currentRepaintsGraphics;
    private final Set<RenderEvent> visibleEvents = new LinkedHashSet<RenderEvent>(1000);
    private final Vector<ModifyClipEvent> clipEvents = new Vector(1000, 1000);
    private int maxWidth = 1;
    private int maxHeight = 1;
    private final SortedSet<DrawImageEvent> drawImagesSkipped = new TreeSet<DrawImageEvent>();

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public WindowState(WindowParser parser, GetGraphicsOutputEvent getGraphics) {
        this.parser = parser;
        this.addRepaint(getGraphics);
    }

    private Repaint getFirstRepaint() {
        return this.repaints.get(0);
    }

    private Repaint getLastRepaint() {
        return this.repaints.get(this.repaints.size() - 1);
    }

    public boolean hasRepaints() {
        return this.repaints.size() > 0;
    }

    public long getWindowID() {
        return this.getFirstRepaint().getGetGraphicsEvent().getObjectID();
    }

    public synchronized void addRepaint(GetGraphicsOutputEvent event) {
        assert (event.representsWindow()) : "A repaint can't be represented by a getGraphics on an Image: " + event;
        this.maxWidth = Math.max(this.maxWidth, event.getWidth());
        this.maxHeight = Math.max(this.maxHeight, event.getHeight());
        if (this.image != null && (this.maxWidth > this.image.getWidth() || this.maxHeight > this.image.getHeight())) {
            this.image = null;
        }
        if (this.image == null) {
            this.image = new BufferedImage(this.maxWidth, this.maxHeight, 2);
        }
        Repaint repaint = new Repaint(event, this.image);
        this.repaints.add(repaint);
        this.currentRepaintsGraphics = (Graphics2D)this.image.getGraphics();
        this.currentRepaintsGraphics.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
        this.currentRepaintsGraphics.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        GetGraphicsOutputEvent getGraphics = repaint.getGetGraphicsEvent();
        if (getGraphics != null) {
            this.currentRepaintsGraphics.translate(getGraphics.getTranslateX(), getGraphics.getTranslateY());
            this.contextsByContextIDs.put(getGraphics.getGraphicsID(), new GraphicsContext(this, this.currentRepaintsGraphics, getGraphics.getTranslateX(), getGraphics.getTranslateY(), true));
        }
    }

    public synchronized Image getImage(long imageID) {
        return this.imagesByImageID.get(imageID);
    }

    public synchronized SortedSet<DrawImageEvent> getDrawImagesSkipped() {
        return this.drawImagesSkipped;
    }

    public synchronized void addEvent(GraphicalOutputEvent event) {
        if (!this.hasRepaints()) {
            this.addRepaint(null);
        }
        if (event instanceof RenderEvent) {
            this.getLastRepaint().addEvent((RenderEvent)event);
        } else if (event instanceof ModifyClipEvent) {
            this.clipEvents.add((ModifyClipEvent)event);
        }
        if (event instanceof GetGraphicsOutputEvent) {
            GetGraphicsOutputEvent getImageEvent = (GetGraphicsOutputEvent)event;
            assert (!getImageEvent.representsWindow()) : "This getGraphics event should have represented a repaint: " + event;
            BufferedImage image = new BufferedImage(getImageEvent.getWidth(), getImageEvent.getHeight(), 2);
            Graphics2D imageContext = (Graphics2D)image.getGraphics();
            imageContext.addRenderingHints(new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON));
            imageContext.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            long imageID = getImageEvent.getObjectID();
            long graphicsID = getImageEvent.getGraphicsID();
            this.imagesByImageID.put(imageID, image);
            this.contextsByContextIDs.put(graphicsID, new GraphicsContext(this, imageContext, getImageEvent.getTranslateX(), getImageEvent.getTranslateY(), false));
            this.imageIDByContextID.put(graphicsID, imageID);
        } else if (event instanceof CreateGraphicsOutputEvent) {
            long sourceID = ((CreateGraphicsOutputEvent)event).getSourceID();
            GraphicsContext currentContext = this.contextsByContextIDs.get(sourceID);
            assert (this.currentRepaintsGraphics != null) : "Window " + this.getWindowID() + ": couldn't find graphics context " + sourceID + " to copy";
            long copyID = ((CreateGraphicsOutputEvent)event).getCopyID();
            assert (this.contextsByContextIDs.get(copyID) == null) : "Already have graphics for " + copyID;
            this.contextsByContextIDs.put(copyID, new GraphicsContext(currentContext));
        } else {
            long id = event.getGraphicsID();
            Object graphicsToUse = null;
            GraphicsContext context = this.contextsByContextIDs.get(id);
            assert (context != null) : "Couldn't find a window or image context matching context ID " + id;
            if (event instanceof SetPaintEvent) {
                context.setLatestPaintChange((SetPaintEvent)event);
            } else if (event instanceof SetCompositeEvent) {
                context.setLatestCompositeChange((SetCompositeEvent)event);
            } else if (event instanceof SetFontEvent) {
                context.setLatestFontChange((SetFontEvent)event);
            } else if (event instanceof ModifyClipEvent) {
                context.setLatestClipChange((ModifyClipEvent)event);
            } else if (event instanceof SetStrokeEvent) {
                context.setLatestStrokeChange((SetStrokeEvent)event);
            } else if (event instanceof ModifyTransformEvent) {
                context.setLatestTransformChange((ModifyTransformEvent)event);
            } else if (event instanceof SetBackgroundEvent) {
                context.setLatestBackgroundChange((SetBackgroundEvent)event);
            }
            if (event instanceof DrawImageEvent && this.imagesByImageID.containsKey(((DrawImageEvent)event).getImageID())) {
                DrawImageEvent drawImage = (DrawImageEvent)event;
                long imageID = drawImage.getImageID();
                Image image = this.imagesByImageID.get(imageID);
                drawImage.paintWithImage(context.getGraphics(), image);
                drawImage.rememberOffscreenBuffer(image);
                drawImage.rememberContext(context);
                List<DrawImageEvent> drawImages = this.drawImageEventByImageID.get(imageID);
                if (drawImages == null) {
                    drawImages = new ArrayList<DrawImageEvent>();
                    this.drawImageEventByImageID.put(imageID, drawImages);
                }
                drawImages.add(drawImage);
            } else {
                event.paint(context.getGraphics());
                if (event instanceof RenderEvent) {
                    ((RenderEvent)event).rememberContext(context);
                }
            }
            if (event instanceof RenderEvent) {
                if (((RenderEvent)event).canOcclude()) {
                    Shape occluder = ((RenderEvent)event).getUnclippedShape();
                    LinkedList<RenderEvent> occludedEvents = new LinkedList<RenderEvent>();
                    for (RenderEvent renderEvent : this.visibleEvents) {
                        if (renderEvent.hasOccluder() || !((RenderEvent)event).occludes(renderEvent)) continue;
                        occludedEvents.add(renderEvent);
                    }
                    for (RenderEvent renderEvent : occludedEvents) {
                        renderEvent.setOccluder((RenderEvent)event);
                        this.visibleEvents.remove(renderEvent);
                    }
                }
                this.visibleEvents.add((RenderEvent)event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Rectangle drawWindowAtEventID(int eventID, BufferedImage targetImage) {
        Repaint lastRepaint = null;
        for (Repaint repaint : this.repaints) {
            if (repaint.getGetGraphicsEvent().representsWindow()) {
                lastRepaint = repaint;
            }
            if (repaint.getGetGraphicsEvent().getEventID() > eventID) break;
        }
        int newWidth = lastRepaint.getGetGraphicsEvent().getWidth();
        int newHeight = lastRepaint.getGetGraphicsEvent().getHeight();
        int newX = 0;
        int newY = 0;
        Graphics2D targetContext = targetImage.createGraphics();
        Image lastImageDrawn = null;
        WindowState windowState = this;
        synchronized (windowState) {
            block4: for (Repaint repaint : this.repaints) {
                if (repaint.getGetGraphicsEvent().getEventID() > eventID) break;
                int x = (int)repaint.getGetGraphicsEvent().getWindowX();
                int y = (int)repaint.getGetGraphicsEvent().getWindowY();
                if (x != 0 || y != 0) {
                    newX = x;
                    newY = y;
                }
                if (this.parser.getLastEventIDParsed() < repaint.getLastEventID()) break;
                if (lastImageDrawn != repaint.getImage()) {
                    if (lastImageDrawn != null) {
                        targetContext.drawImage(lastImageDrawn, 0, 0, null);
                    }
                    lastImageDrawn = repaint.getImage();
                    Graphics2D imageGraphics = (Graphics2D)lastImageDrawn.getGraphics();
                    imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    imageGraphics.setColor(UI.getPanelLightColor());
                    imageGraphics.fillRect(0, 0, lastImageDrawn.getWidth(null), lastImageDrawn.getHeight(null));
                }
                lastRepaint = repaint;
                if (repaint.getGetGraphicsEvent().getEventID() > eventID) break;
                for (RenderEvent event : repaint) {
                    if (event.getEventID() > eventID) continue block4;
                    if (!event.isVisibleAfter(eventID)) continue;
                    event.paintByMemory();
                }
            }
        }
        targetContext.drawImage(lastImageDrawn, 0, 0, null);
        return new Rectangle(newX, newY, newWidth, newHeight);
    }

    public synchronized Rectangle getEntityBoundsBefore(long entityID, int eventID) {
        Rectangle bounds = null;
        for (Repaint repaint : this.repaints) {
            if (repaint.getGetGraphicsEvent().getEventID() > eventID) break;
            for (RenderEvent event : repaint) {
                long entity;
                if (!event.isVisibleAfter(eventID) || (entity = event.getInstanceResponsible()) != entityID) continue;
                Rectangle rect = event.getClippedBoundaries();
                bounds = bounds == null ? rect : bounds.union(rect);
            }
        }
        if (bounds == null) {
            for (Repaint repaint : this.repaints) {
                if (repaint.getGetGraphicsEvent().getEventID() > eventID) break;
                for (RenderEvent event : repaint) {
                    if (!event.isVisibleAfter(eventID) || !event.isIndirectlyRenderedBy(entityID)) continue;
                    Rectangle rect = event.getClippedBoundaries();
                    bounds = bounds == null ? rect : bounds.union(rect);
                }
            }
        }
        return bounds;
    }

    public synchronized SortedSet<GraphicalEventAppearance> getRenderEventsAtLocationAfterEventID(int x, int y, int eventID) {
        TreeSet<GraphicalEventAppearance> events = new TreeSet<GraphicalEventAppearance>();
        this.drawImagesSkipped.clear();
        boolean done = false;
        block0: for (Repaint repaint : this.repaints) {
            if (done) break;
            for (RenderEvent event : repaint) {
                if (event.getEventID() > eventID) {
                    done = true;
                    continue block0;
                }
                long graphicsID = event.getGraphicsID();
                GraphicsContext context = this.contextsByContextIDs.get(graphicsID);
                if (!context.representsWindow()) {
                    long imageID = this.imageIDByContextID.get(graphicsID);
                    List<DrawImageEvent> drawImages = this.drawImageEventByImageID.get(imageID);
                    if (drawImages == null) continue;
                    for (DrawImageEvent draw : drawImages) {
                        if (!draw.isVisibleAfter(eventID) || !draw.contains(x, y)) continue;
                        event.setRenderers(drawImages);
                        this.drawImagesSkipped.add(draw);
                        if (!event.contains(x - draw.getWindowX(), y - draw.getWindowY())) continue;
                        events.add(new GraphicalEventAppearance(event, draw));
                    }
                    continue;
                }
                if (!event.isVisibleAfter(eventID) || !event.contains(x, y) || this.drawImagesSkipped.contains(event)) continue;
                events.add(new GraphicalEventAppearance(event, event));
            }
        }
        return events;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Repaint
    implements Iterable<RenderEvent> {
        private final GetGraphicsOutputEvent event;
        private final LinkedList<RenderEvent> eventsByRepaint = new LinkedList();
        private final Image image;

        public Repaint(GetGraphicsOutputEvent event, Image image) {
            this.event = event;
            this.image = image;
        }

        public GetGraphicsOutputEvent getGetGraphicsEvent() {
            return this.event;
        }

        public boolean hasEvents() {
            return this.eventsByRepaint.size() > 0;
        }

        public void addEvent(RenderEvent event) {
            assert (event != null) : "Event is null!";
            this.eventsByRepaint.add(event);
        }

        public int getLastEventID() {
            return this.eventsByRepaint.isEmpty() ? -1 : this.eventsByRepaint.getLast().getEventID();
        }

        public Image getImage() {
            return this.image;
        }

        @Override
        public Iterator<RenderEvent> iterator() {
            return this.eventsByRepaint.iterator();
        }
    }
}

