/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.trace.CallStack;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.Value;

public abstract class IOEvent {
    protected final Trace trace;
    protected final int eventID;

    public IOEvent(Trace trace, int eventID) {
        this.trace = trace;
        this.eventID = eventID;
    }

    public Instruction getInstruction() {
        return this.trace.getInstruction(this.eventID);
    }

    public int getEventID() {
        return this.eventID;
    }

    public Value getArgument(int argument) {
        return this.trace.getOperandStackValue(this.eventID, argument);
    }

    public abstract boolean segmentsOutput();

    public Trace getTrace() {
        return this.trace;
    }

    public CallStack getCallStack() {
        return this.trace.getCallStack(this.eventID);
    }

    public int getNumberOfArgumentProducers() {
        return this.trace.getInstruction(this.eventID).getNumberOfArgumentProducers();
    }

    public abstract String getHTMLDescription();
}

