/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.io.OutputEvent;
import edu.cmu.hcii.whyline.trace.CallStack;
import edu.cmu.hcii.whyline.trace.CallStackEntry;
import edu.cmu.hcii.whyline.trace.NoValueException;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.util.Named;
import edu.cmu.hcii.whyline.util.Util;
import java.awt.Graphics2D;
import java.util.Arrays;

public abstract class GraphicalOutputEvent
extends OutputEvent
implements Named {
    private long instanceResponsible = -1L;
    private long graphicsIDCache = 0L;
    private int[] intCache;

    public GraphicalOutputEvent(Trace trace, int eventID) {
        super(trace, eventID);
    }

    public abstract String getHumanReadableName();

    public String getDisplayName(boolean html, int lengthLimit) {
        return this.getHumanReadableName();
    }

    public long getInstanceResponsible() {
        if (this.instanceResponsible >= 0L) {
            return this.instanceResponsible;
        }
        CallStack callStack = this.trace.getCallStack(this.eventID);
        this.instanceResponsible = 0L;
        int i = callStack.getDepth() - 1;
        while (i >= 0) {
            CallStackEntry entry = callStack.getEntryAt(i);
            int invocationID = entry.getInvocationID();
            if (invocationID >= 0) {
                QualifiedClassName classOfInstanceCalled = this.trace.getInvocationClassInvokedOn(invocationID);
                boolean classIsReferenced = this.trace.classIsReferencedInFamiliarSourceFile(classOfInstanceCalled);
                long id = this.trace.getInvocationInstanceID(invocationID);
                if (id > 0L && classIsReferenced) {
                    this.instanceResponsible = id;
                    break;
                }
            }
            --i;
        }
        return this.instanceResponsible;
    }

    public boolean isIndirectlyRenderedBy(long entityID) {
        CallStack callStack = this.trace.getCallStack(this.eventID);
        int i = callStack.getDepth() - 1;
        while (i >= 0) {
            long id;
            CallStackEntry entry = callStack.getEntryAt(i);
            int invocationID = entry.getInvocationID();
            if (invocationID >= 0 && (id = this.trace.getInvocationInstanceID(invocationID)) == entityID) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected int getInteger(int arg) {
        if (this.intCache == null) {
            this.intCache = new int[5];
            Arrays.fill(this.intCache, Integer.MAX_VALUE);
        } else if (arg < this.intCache.length && this.intCache[arg] != Integer.MAX_VALUE) {
            return this.intCache[arg];
        }
        try {
            int value = this.trace.getOperandStackValue(this.eventID, arg).getInteger();
            if (arg < this.intCache.length) {
                this.intCache[arg] = value;
            }
            return value;
        }
        catch (NoValueException e) {
            return 0;
        }
    }

    protected long getLong(int arg) {
        return this.trace.getOperandStackValue(this.eventID, arg).getLong();
    }

    protected boolean getBoolean(int arg) {
        try {
            return this.trace.getOperandStackValue(this.eventID, arg).getBoolean();
        }
        catch (NoValueException e) {
            return false;
        }
    }

    protected float getFloat(int arg) {
        try {
            return this.trace.getOperandStackValue(this.eventID, arg).getFloat();
        }
        catch (NoValueException e) {
            return 0.0f;
        }
    }

    protected double getDouble(int arg) {
        try {
            return this.trace.getOperandStackValue(this.eventID, arg).getDouble();
        }
        catch (NoValueException e) {
            return 0.0;
        }
    }

    public long getGraphicsID() {
        if (this.graphicsIDCache == 0L) {
            this.graphicsIDCache = this.getLong(0);
        }
        return this.graphicsIDCache;
    }

    public abstract void paint(Graphics2D var1);

    public String toString() {
        return String.valueOf(Util.fillOrTruncateString(this.trace.getInstruction(this.eventID).getMethod().getQualifiedNameAndDescriptor(), 40)) + " eventID=" + this.getEventID() + " ";
    }
}

