/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.trace.NoValueException;
import edu.cmu.hcii.whyline.trace.Trace;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public final class FillEvent
extends RenderEvent {
    private static final String[] ARGUMENT_NAMES = new String[]{"graphics", "shape"};
    private final Shape shape;

    public String getArgumentName(int index) {
        return ARGUMENT_NAMES[index];
    }

    public FillEvent(Trace trace, int eventID) {
        super(trace, eventID);
        Shape s = null;
        try {
            s = (Shape)trace.getOperandStackValue(eventID, 1).getImmutable();
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
        this.shape = s;
    }

    public void paint(Graphics2D g) {
        g.fill(this.shape);
    }

    protected Shape makeShape() {
        Rectangle r = this.shape.getBounds();
        r.translate(this.paintState.getOriginX(), this.paintState.getOriginY());
        return r;
    }

    public String getHumanReadableName() {
        return "filled shape";
    }

    public boolean canOcclude() {
        return true;
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.getGraphicsID() + "\tfill " + this.shape;
    }
}

