/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.trace.Trace;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;

public final class Fill3DRectEvent
extends RenderEvent {
    private static final String[] ARGUMENT_NAMES = new String[]{"graphics", "x", "y", "width", "height", "raised"};

    public String getArgumentName(int index) {
        return ARGUMENT_NAMES[index];
    }

    public Fill3DRectEvent(Trace trace, int eventID) {
        super(trace, eventID);
    }

    public void paint(Graphics2D g) {
        g.fill3DRect(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getRaised());
    }

    protected Shape makeShape() {
        return new Rectangle(this.getX() + this.paintState.getOriginX(), this.getY() + this.paintState.getOriginY(), this.getWidth(), this.getHeight());
    }

    public int getX() {
        return this.getInteger(1);
    }

    public int getY() {
        return this.getInteger(2);
    }

    public int getWidth() {
        return this.getInteger(3);
    }

    public int getHeight() {
        return this.getInteger(4);
    }

    public boolean getRaised() {
        return this.getBoolean(5);
    }

    public String getHumanReadableName() {
        return "filled 3D rectangle";
    }

    public boolean canOcclude() {
        return true;
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.getGraphicsID() + "\tdraw3DRect " + this.getX() + " " + this.getY() + " " + this.getWidth() + " " + this.getHeight();
    }
}

