/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.io.RenderEvent;
import edu.cmu.hcii.whyline.trace.NoValueException;
import edu.cmu.hcii.whyline.trace.Trace;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public final class DrawStringEvent
extends RenderEvent {
    private static final String[] ARGUMENT_NAMES = new String[]{"graphics", "text", "x", "y"};
    private String string;
    private Graphics2D renderContext;
    private final boolean usesFloats;

    public String getArgumentName(int index) {
        return ARGUMENT_NAMES[index];
    }

    public DrawStringEvent(Trace trace, int eventID) {
        super(trace, eventID);
        this.usesFloats = ((Invoke)trace.getInstruction(eventID)).getMethodInvoked().getMethodDescriptor().equals("(Ljava/lang/String;FF)V");
    }

    public void paint(Graphics2D g) {
        g.drawString(this.getString(), this.getX(), this.getY());
        if (this.renderContext == null) {
            this.renderContext = g;
        }
    }

    protected Shape makeShape() {
        if (this.renderContext == null) {
            return null;
        }
        Font font = this.paintState.getLatestFontChange().getFont();
        FontMetrics metrics = this.renderContext.getFontMetrics(font);
        Rectangle2D r = metrics.getStringBounds(this.getString(), this.renderContext);
        int ascent = metrics.getAscent();
        return font.createGlyphVector(this.renderContext.getFontRenderContext(), this.string).getOutline(this.getX() + this.paintState.getOriginX(), this.getY() + this.paintState.getOriginY());
    }

    public String getString() {
        if (this.string == null) {
            try {
                this.string = (String)this.getArgument(1).getImmutable();
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
        }
        return this.string;
    }

    public int getX() {
        return this.usesFloats ? (int)this.getFloat(2) : this.getInteger(2);
    }

    public int getY() {
        return this.usesFloats ? (int)this.getFloat(3) : this.getInteger(3);
    }

    public String getHumanReadableName() {
        return "text";
    }

    public boolean canOcclude() {
        return false;
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.getGraphicsID() + "\tdrawString " + this.getX() + " " + this.getY() + " " + this.getString();
    }
}

