/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.io;

import edu.cmu.hcii.whyline.io.DrawImageEvent;
import edu.cmu.hcii.whyline.trace.Trace;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;

public final class DrawImageWithSizeWithinAreaEvent
extends DrawImageEvent {
    private static final String[] ARGUMENT_NAMES = new String[]{"graphics", "image", "destination x1", "destination y1", "destination x2", "destination y2", "source x1", "source y1", "source x2", "source y2", "observer"};

    public String getArgumentName(int index) {
        return ARGUMENT_NAMES[index];
    }

    public DrawImageWithSizeWithinAreaEvent(Trace trace, int eventID) {
        super(trace, eventID);
    }

    public void paintWithImage(Graphics2D g, Image image) {
        if (image == null) {
            double destX = Math.min(this.getDX1(), this.getDX2());
            double destY = Math.min(this.getDY1(), this.getDY2());
            double destWidth = Math.abs(this.getDX1() - this.getDX2());
            double destHeight = Math.abs(this.getDY1() - this.getDY2());
            this.drawPlaceholder(g, "image " + this.getImageID(), (int)destX, (int)destY, (int)destWidth, (int)destHeight, null);
        } else {
            g.drawImage(image, this.getDX1(), this.getDY1(), this.getDX2(), this.getDY2(), this.getSX1(), this.getSY1(), this.getSX2(), this.getSY2(), null);
        }
    }

    protected Shape makeShape() {
        return new Rectangle(this.getWindowX(), this.getWindowY(), Math.abs(this.getDX1() - this.getDX2()), Math.abs(this.getDY1() - this.getDY2()));
    }

    public int getWindowX() {
        return this.paintState.getOriginX() + Math.min(this.getDX1(), this.getDX2());
    }

    public int getWindowY() {
        return this.paintState.getOriginY() + Math.min(this.getDY1(), this.getDY2());
    }

    public void transformContextToDrawPrimitive(Graphics2D g) {
        g.translate(this.getWindowX(), this.getWindowY());
    }

    public int getDX1() {
        return this.getInteger(2);
    }

    public int getDY1() {
        return this.getInteger(3);
    }

    public int getDX2() {
        return this.getInteger(4);
    }

    public int getDY2() {
        return this.getInteger(5);
    }

    public int getSX1() {
        return this.getInteger(6);
    }

    public int getSY1() {
        return this.getInteger(7);
    }

    public int getSX2() {
        return this.getInteger(8);
    }

    public int getSY2() {
        return this.getInteger(9);
    }

    public long getObserver() {
        return this.getLong(10);
    }

    public String getHumanReadableName() {
        return "scaled image";
    }

    public String toString() {
        return String.valueOf(super.toString()) + "\tdrawImageWithSizeWithinArea " + this.getImage() + " " + this.getDX1() + " " + this.getDY1() + " " + this.getDX2() + " " + this.getDY2() + " " + this.getSX1() + " " + this.getSY1() + " " + this.getSX2() + " " + this.getSY2();
    }
}

