/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.ConstantPoolInfo;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import edu.cmu.hcii.whyline.trace.EventKind;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class NameAndTypeInfo
extends ConstantPoolInfo {
    public static final int tag = 12;
    private int indexOfName;
    private int indexOfTypeDescriptor;
    private UTF8Info name;
    private UTF8Info descriptor;
    private String toStringCache;

    public NameAndTypeInfo(ConstantPool pool, DataInputStream in) throws IOException {
        super(pool);
        this.indexOfName = in.readUnsignedShort();
        this.indexOfTypeDescriptor = in.readUnsignedShort();
    }

    public NameAndTypeInfo(ConstantPool pool, UTF8Info methodName, UTF8Info signature) {
        super(pool);
        this.name = methodName;
        this.descriptor = signature;
    }

    public void resolveDependencies() {
        this.name = (UTF8Info)this.pool.get(this.indexOfName);
        this.descriptor = (UTF8Info)this.pool.get(this.indexOfTypeDescriptor);
    }

    public void toBytes(DataOutputStream bytes) throws IOException {
        bytes.writeByte(12);
        bytes.writeShort(this.name.getIndexInConstantPool());
        bytes.writeShort(this.descriptor.getIndexInConstantPool());
    }

    public String getName() {
        return this.name.toString();
    }

    public String getTypeDescriptor() {
        return this.descriptor.toString();
    }

    public static EventKind typeCharacterToClass(char c) {
        switch (c) {
            case 'B': {
                return EventKind.BYTE_PRODUCED;
            }
            case 'C': {
                return EventKind.CHARACTER_PRODUCED;
            }
            case 'D': {
                return EventKind.DOUBLE_PRODUCED;
            }
            case 'F': {
                return EventKind.FLOAT_PRODUCED;
            }
            case 'I': {
                return EventKind.INTEGER_PRODUCED;
            }
            case 'J': {
                return EventKind.LONG_PRODUCED;
            }
            case 'S': {
                return EventKind.SHORT_PRODUCED;
            }
            case 'Z': {
                return EventKind.BOOLEAN_PRODUCED;
            }
            case 'L': {
                return EventKind.OBJECT_PRODUCED;
            }
            case '[': {
                return EventKind.OBJECT_PRODUCED;
            }
        }
        return null;
    }

    public static String sourceTypeToDescriptorType(String type) {
        StringBuilder builder = new StringBuilder();
        int lastBracketIndex = type.lastIndexOf(91);
        if (lastBracketIndex >= 0) {
            builder.append(type.substring(0, lastBracketIndex + 1));
            type = type.substring(lastBracketIndex + 1);
        }
        if (type.equals("boolean")) {
            builder.append("Z");
        } else if (type.equals("char")) {
            builder.append("C");
        } else if (type.equals("double")) {
            builder.append("D");
        } else if (type.equals("float")) {
            builder.append("F");
        } else if (type.equals("int")) {
            builder.append("I");
        } else if (type.equals("long")) {
            builder.append("J");
        } else if (type.equals("short")) {
            builder.append("S");
        } else if (type.equals("byte")) {
            builder.append("B");
        } else {
            builder.append("L");
            builder.append(type);
            builder.append(";");
        }
        return builder.toString();
    }

    public static String getJavafiedTypeDescriptor(String type) {
        if (type.startsWith("L")) {
            return NameAndTypeInfo.getJavafiedObjectTypeDescriptor(type);
        }
        if (type.startsWith("[")) {
            int lastBracket = type.lastIndexOf(91);
            String brackets = type.substring(0, lastBracket + 1);
            String objectType = NameAndTypeInfo.getJavafiedTypeDescriptor(type.substring(lastBracket + 1));
            int i = 0;
            while (i < brackets.length()) {
                objectType = String.valueOf(objectType) + "[]";
                ++i;
            }
            return objectType;
        }
        return NameAndTypeInfo.getJavafiedPrimitiveTypeDescriptor(type.charAt(0));
    }

    public static String getJavafiedObjectTypeDescriptor(String objectType) {
        assert (objectType.startsWith("L") && objectType.endsWith(";")) : objectType + " isn't an object type, it doesn't start with L and end with ;";
        return objectType.substring(1, objectType.length() - 1).replace('/', '.');
    }

    public static String getJavafiedPrimitiveTypeDescriptor(char c) {
        switch (c) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'Z': {
                return "boolean";
            }
            case 'V': {
                return "void";
            }
        }
        return null;
    }

    public boolean equals(Object o) {
        return o instanceof NameAndTypeInfo && ((NameAndTypeInfo)o).name.equals(this.name) && ((NameAndTypeInfo)o).descriptor.equals(this.descriptor);
    }

    public String toString() {
        if (this.toStringCache == null) {
            StringBuilder builder = new StringBuilder(this.getName());
            builder.append(this.getTypeDescriptor());
            this.toStringCache = builder.toString();
        }
        return this.toStringCache;
    }
}

