/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodDescriptor
implements Iterable<String> {
    public static final String BYTE = "B";
    public static final String CHAR = "C";
    public static final String DOUBLE = "D";
    public static final String FLOAT = "F";
    public static final String INT = "I";
    public static final String LONG = "J";
    public static final String SHORT = "S";
    public static final String BOOLEAN = "Z";
    public static final String VOID = "V";
    private final String[] parameterTypes;
    private final String returnType;
    private final boolean isStatic;
    private static HashMap<String, MethodDescriptor> staticDescriptors = new HashMap(10);
    private static HashMap<String, MethodDescriptor> nonStaticDescriptors = new HashMap(10);

    public static MethodDescriptor get(boolean isStatic, String descriptor) {
        MethodDescriptor desc;
        MethodDescriptor methodDescriptor = desc = isStatic ? staticDescriptors.get(descriptor) : nonStaticDescriptors.get(descriptor);
        if (desc == null) {
            desc = new MethodDescriptor(isStatic, descriptor);
            if (isStatic) {
                staticDescriptors.put(descriptor, desc);
            } else {
                nonStaticDescriptors.put(descriptor, desc);
            }
        }
        return desc;
    }

    private MethodDescriptor(boolean isStatic, String descriptor) {
        this.isStatic = isStatic;
        ArrayList<String> parameterTypes = new ArrayList<String>(5);
        int closingParenIndex = descriptor.lastIndexOf(41);
        int index = 1;
        while (index != closingParenIndex) {
            int indexOfTypeStart = index;
            while (descriptor.charAt(index) == '[') {
                ++index;
            }
            if (descriptor.charAt(index) == 'L') {
                while (descriptor.charAt(index) != ';') {
                    ++index;
                }
            }
            String type = descriptor.substring(indexOfTypeStart, index + 1);
            type = type.intern();
            parameterTypes.add(type);
            ++index;
        }
        String rest = descriptor.substring(++index);
        this.returnType = rest.intern();
        this.parameterTypes = new String[parameterTypes.size()];
        parameterTypes.toArray(this.parameterTypes);
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < MethodDescriptor.this.parameterTypes.length;
            }

            @Override
            public String next() {
                return MethodDescriptor.this.parameterTypes[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Can't remove method descriptor types.");
            }
        };
    }

    public String getSimpleDescriptor() {
        StringBuilder builder = new StringBuilder("(");
        String[] stringArray = this.parameterTypes;
        int n = this.parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            builder.append(MethodDescriptor.dequalifyClassname(param));
            ++n2;
        }
        builder.append(")");
        return builder.toString();
    }

    private static String dequalifyClassname(String param) {
        int elIndex = param.indexOf(76);
        int lastIndex = Math.max(param.lastIndexOf(47), param.lastIndexOf(36));
        if (elIndex >= 0 && lastIndex >= 0) {
            StringBuilder builder = new StringBuilder();
            builder.append(param.substring(0, elIndex + 1));
            builder.append(param.substring(lastIndex + 1));
            return builder.toString();
        }
        return param;
    }

    public int getNumberOfParameters() {
        return this.parameterTypes.length;
    }

    public QualifiedClassName getReturnType() {
        return QualifiedClassName.getFromTypeDescriptor(this.returnType);
    }

    public QualifiedClassName getTypeOfArgumentNumber(int argumentNumber) {
        assert (argumentNumber >= 0 && argumentNumber < this.parameterTypes.length) : "Illegal parameter type index: " + argumentNumber + " must be between 0 and " + (this.parameterTypes.length - 1) + " inclusive.";
        return QualifiedClassName.getFromTypeDescriptor(this.parameterTypes[argumentNumber]);
    }

    public int getArgumentNumberFromLocalID(int localID) {
        int currentIndex;
        if (!this.isStatic && localID == 0) {
            return 0;
        }
        int argumentNumber = currentIndex = this.isStatic ? 0 : 1;
        String[] stringArray = this.parameterTypes;
        int n = this.parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (currentIndex == localID) {
                return argumentNumber;
            }
            currentIndex += type.equals(DOUBLE) || type.equals(LONG) ? 2 : 1;
            ++argumentNumber;
            ++n2;
        }
        return -1;
    }

    public int getLocalIDFromArgumentNumber(int argumentNumber) {
        int currentArgument;
        if (argumentNumber < 0) {
            return -1;
        }
        if (argumentNumber == 0) {
            return 0;
        }
        int currentIndex = currentArgument = this.isStatic ? 0 : 1;
        String[] stringArray = this.parameterTypes;
        int n = this.parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            if (currentArgument == argumentNumber) {
                return currentIndex;
            }
            currentIndex += type.equals(DOUBLE) || type.equals(LONG) ? 2 : 1;
            ++currentArgument;
            ++n2;
        }
        return -1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        String[] stringArray = this.parameterTypes;
        int n = this.parameterTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            builder.append(s);
            ++n2;
        }
        builder.append(")");
        builder.append(this.returnType);
        return builder.toString();
    }

    public String getJavaDocURL() {
        StringBuilder url = new StringBuilder();
        url.append("(");
        int i = 0;
        while (i < this.parameterTypes.length) {
            url.append(this.getTypeOfArgumentNumber(i).getNameWithDots());
            if (i < this.parameterTypes.length - 1) {
                url.append(",%20");
            }
            ++i;
        }
        url.append(")");
        return url.toString();
    }
}

