/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.ArrayAllocation;
import edu.cmu.hcii.whyline.bytecode.ClassInfo;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.trace.EventKind;
import java.io.DataOutputStream;
import java.io.IOException;

public final class MULTIANEWARRAY
extends ArrayAllocation {
    private ClassInfo typeInfo;
    private int numberOfDimensions;

    public MULTIANEWARRAY(CodeAttribute method, ClassInfo typeInfo, int numberOfDimensions) {
        super(method);
        this.typeInfo = typeInfo;
        this.numberOfDimensions = numberOfDimensions;
    }

    public final int getOpcode() {
        return 197;
    }

    public int byteLength() {
        return 4;
    }

    public int getNumberOfDimensions() {
        return this.numberOfDimensions;
    }

    public int getNumberOfOperandsConsumed() {
        return this.numberOfDimensions;
    }

    public int getNumberOfOperandsProduced() {
        return 1;
    }

    public int getNumberOfOperandsPeekedAt() {
        return 0;
    }

    public void toBytes(DataOutputStream code) throws IOException {
        code.writeByte(this.getOpcode());
        code.writeShort(this.typeInfo.getIndexInConstantPool());
        code.writeByte(this.numberOfDimensions);
    }

    public EventKind getTypeProduced() {
        return EventKind.OBJECT_PRODUCED;
    }

    public String getTypeDescriptorOfArgument(int argIndex) {
        return "I";
    }

    public QualifiedClassName getClassnameOfTypeProduced() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < this.numberOfDimensions) {
            builder.append("[");
            ++i;
        }
        builder.append("L");
        builder.append(this.typeInfo.getName());
        builder.append(";");
        return QualifiedClassName.get(builder.toString());
    }
}

