/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.Attribute;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalVariableTableAttribute
extends Attribute {
    private final UTF8Info attributeName;
    private final CodeAttribute code;
    private final ConstantPool pool;
    private int length;
    private LocalVariable[] table;
    private byte[] bytes;

    public LocalVariableTableAttribute(CodeAttribute code, UTF8Info attributeName, int length, ConstantPool pool, DataInputStream data) throws IOException {
        this.code = code;
        this.pool = pool;
        this.attributeName = attributeName;
        this.length = length;
        this.bytes = new byte[length];
        data.readFully(this.bytes);
    }

    private void parseTable() {
        if (this.table == null) {
            try {
                DataInputStream data = new DataInputStream(new ByteArrayInputStream(this.bytes));
                int tableLength = data.readUnsignedShort();
                this.table = new LocalVariable[tableLength];
                int i = 0;
                while (i < tableLength) {
                    this.table[i] = new LocalVariable(data.readUnsignedShort(), data.readUnsignedShort(), (UTF8Info)this.pool.get(data.readUnsignedShort()), (UTF8Info)this.pool.get(data.readUnsignedShort()), data.readUnsignedShort());
                    ++i;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.bytes = null;
        }
    }

    @Override
    public void toBytes(DataOutputStream stream) throws IOException {
        this.parseTable();
        stream.writeShort(this.attributeName.getIndexInConstantPool());
        stream.writeInt(this.getAttributeLengthWithoutNameAndLength());
        stream.writeShort(this.table.length);
        LocalVariable[] localVariableArray = this.table;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable var = localVariableArray[n2];
            stream.writeShort(var.startPC);
            stream.writeShort(var.length);
            stream.writeShort(var.name.getIndexInConstantPool());
            stream.writeShort(var.descriptor.getIndexInConstantPool());
            stream.writeShort(var.index);
            ++n2;
        }
    }

    @Override
    public int getTotalAttributeLength() {
        this.parseTable();
        return 8 + this.table.length * 10;
    }

    public boolean isLocalIDDefinedRelativeToInstruction(int localID, Instruction instruction) {
        return this.getNameOfLocalIDRelativeToInstruction(localID, instruction) != null;
    }

    public String getNameOfLocalIDRelativeToInstruction(int localID, Instruction instruction) {
        this.parseTable();
        LocalVariable[] localVariableArray = this.table;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable var = localVariableArray[n2];
            if (var.localIDIsDefinedAt(localID, instruction.getByteIndex())) {
                return var.name.toString();
            }
            ++n2;
        }
        return null;
    }

    public String getDescriptorOfLocalIDRelativeToInstruction(int localID, Instruction instruction) {
        this.parseTable();
        LocalVariable[] localVariableArray = this.table;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable var = localVariableArray[n2];
            if (var.localIDIsDefinedAt(localID, instruction.getByteIndex())) {
                return var.descriptor.toString();
            }
            ++n2;
        }
        return null;
    }

    public int getLocalIDOfNameRelativeToInstruction(String name, Instruction instruction) {
        this.parseTable();
        LocalVariable[] localVariableArray = this.table;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable var = localVariableArray[n2];
            if (var.nameIsDefinedAt(name, instruction.getByteIndex())) {
                return var.index;
            }
            ++n2;
        }
        return -1;
    }

    public int getNumberOfLocals() {
        this.parseTable();
        return this.table.length;
    }

    public String getDescriptorOf(int uniqueID) {
        this.parseTable();
        return this.table[uniqueID].descriptor.toString();
    }

    public boolean localIDIsDefinedAt(int localID, Instruction inst) {
        this.parseTable();
        assert (inst.getCode() == this.code) : "But the method of the instruction, " + inst.getMethod() + ", isn't in the same method as this local table's, " + this.code.getMethod();
        int byteIndex = inst.getByteIndex();
        LocalVariable[] localVariableArray = this.table;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable var = localVariableArray[n2];
            if (var.localIDIsDefinedAt(localID, byteIndex)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        this.parseTable();
        String result = "";
        int id = 0;
        while (id < this.table.length) {
            result = String.valueOf(result) + this.table[id].toString() + "\n";
            ++id;
        }
        return result;
    }

    public Set<String> getLocalNames() {
        this.parseTable();
        HashSet<String> names = new HashSet<String>();
        LocalVariable[] localVariableArray = this.table;
        int n = this.table.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable var = localVariableArray[n2];
            names.add(var.name.toString());
            ++n2;
        }
        return names;
    }

    private class LocalVariable {
        public int startPC;
        public int length;
        public UTF8Info name;
        public UTF8Info descriptor;
        public int index;

        public LocalVariable(int start, int length, UTF8Info name, UTF8Info descriptor, int index) {
            this.startPC = start;
            this.length = length;
            this.name = name;
            this.descriptor = descriptor;
            this.index = index;
        }

        public boolean localIDIsDefinedAt(int localID, int byteIndex) {
            return localID == this.index && byteIndex >= this.startPC && byteIndex <= this.startPC + this.length;
        }

        public boolean nameIsDefinedAt(String name, int byteIndex) {
            return this.name.toString().equals(name) && byteIndex >= this.startPC && byteIndex <= this.startPC + this.length;
        }

        public String toString() {
            return this.name + " of type " + this.descriptor + " is defined at [" + this.startPC + ", " + (this.startPC + this.length) + "] inclusive at index " + this.index;
        }
    }
}

