/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.Attribute;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.LineNumber;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LineNumberTableAttribute
extends Attribute {
    private final UTF8Info attributeName;
    private final int attributeLength;
    private final ConstantPool pool;
    private CodeAttribute code;
    private LineNumberTableEntry[] lines;
    private int lineNumberTableLength;
    private byte[] bytes;

    public LineNumberTableAttribute(UTF8Info attributeName, CodeAttribute owner, ConstantPool pool, DataInputStream data, int length) throws IOException {
        this.pool = pool;
        this.attributeName = attributeName;
        this.attributeLength = length;
        this.code = owner;
        this.bytes = new byte[this.attributeLength];
        data.readFully(this.bytes);
    }

    private LineNumberTableEntry[] parseLines() {
        if (this.lines == null) {
            try {
                DataInputStream data = new DataInputStream(new ByteArrayInputStream(this.bytes));
                this.lineNumberTableLength = data.readUnsignedShort();
                this.lines = new LineNumberTableEntry[this.lineNumberTableLength];
                int i = 0;
                while (i < this.lineNumberTableLength) {
                    int startPC = data.readUnsignedShort();
                    int line = data.readUnsignedShort();
                    Instruction inst = this.code.getInstructionAtByteIndex(startPC);
                    this.lines[i] = new LineNumberTableEntry(this.pool.getClassfile(), inst, line);
                    ++i;
                }
                this.bytes = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.lines;
    }

    @Override
    public void toBytes(DataOutputStream stream) throws IOException {
        stream.writeShort(this.attributeName.getIndexInConstantPool());
        stream.writeInt(this.getAttributeLengthWithoutNameAndLength());
        if (this.lines == null) {
            stream.write(this.bytes);
        } else {
            stream.writeShort(this.lineNumberTableLength);
            LineNumberTableEntry[] lineNumberTableEntryArray = this.lines;
            int n = this.lines.length;
            int n2 = 0;
            while (n2 < n) {
                LineNumberTableEntry pair = lineNumberTableEntryArray[n2];
                stream.writeShort(pair.startPC.getByteIndex());
                stream.writeShort(pair.getLineNumber().getNumber());
                ++n2;
            }
        }
    }

    public LineNumber getLineNumberOf(Instruction inst) {
        LineNumberTableEntry[] entries = this.parseLines();
        if (entries.length == 1) {
            return entries[0].getLineNumber();
        }
        Instruction instructionOfPreviousRow = entries[0].startPC;
        int currentRow = 1;
        while (currentRow < entries.length) {
            if (instructionOfPreviousRow.getByteIndex() <= inst.getByteIndex() && inst.getByteIndex() < entries[currentRow].startPC.getByteIndex()) {
                return entries[currentRow - 1].getLineNumber();
            }
            instructionOfPreviousRow = entries[currentRow].startPC;
            ++currentRow;
        }
        if (inst.getByteIndex() >= entries[entries.length - 1].startPC.getByteIndex()) {
            return entries[entries.length - 1].getLineNumber();
        }
        return null;
    }

    public LineNumber getFirstLineNumber() {
        LineNumberTableEntry[] entries = this.parseLines();
        LineNumber smallest = null;
        int i = 0;
        while (i < entries.length) {
            if (smallest == null || entries[i].getLineNumber().isBefore(smallest)) {
                smallest = entries[i].getLineNumber();
            }
            ++i;
        }
        return smallest;
    }

    public LineNumber getLastLineNumber() {
        LineNumberTableEntry[] entries = this.parseLines();
        LineNumber largest = null;
        int i = 0;
        while (i < entries.length) {
            if (largest == null || entries[i].getLineNumber().isAfter(largest)) {
                largest = entries[i].getLineNumber();
            }
            ++i;
        }
        return largest;
    }

    @Override
    public int getTotalAttributeLength() {
        return 6 + this.attributeLength;
    }

    public void getInstructionsOnLineNumber(SortedSet<Instruction> instructions, LineNumber lineNumber) {
        LineNumberTableEntry[] entries = this.parseLines();
        int tableRowThatMatchesLineNumber = 0;
        tableRowThatMatchesLineNumber = 0;
        while (tableRowThatMatchesLineNumber < entries.length) {
            if (entries[tableRowThatMatchesLineNumber].getLineNumber().is(lineNumber)) {
                Instruction currentInstruction = entries[tableRowThatMatchesLineNumber].startPC;
                while (currentInstruction != null && currentInstruction.getLineNumber().is(lineNumber)) {
                    instructions.add(currentInstruction);
                    currentInstruction = currentInstruction.getNext();
                }
            }
            ++tableRowThatMatchesLineNumber;
        }
    }

    private String getStringFormOfTable() {
        LineNumberTableEntry[] entries = this.parseLines();
        String string = "***\n";
        int i = 0;
        while (i < entries.length) {
            string = String.valueOf(string) + entries[i].line + " starts at byte index " + entries[i].startPC + "\n";
            ++i;
        }
        return String.valueOf(string) + "***\n";
    }

    private static class LineNumberTableEntry {
        public final Instruction startPC;
        private final int line;
        private LineNumber lineNumber;
        private final Classfile classfile;

        public LineNumberTableEntry(Classfile classfile, Instruction startPC, int line) {
            this.classfile = classfile;
            this.startPC = startPC;
            this.line = line;
        }

        public LineNumber getLineNumber() {
            if (this.lineNumber == null) {
                JavaSourceFile source = this.classfile.getSourceFile();
                this.lineNumber = new LineNumber(source == null ? this.classfile : source, this.line);
            }
            return this.lineNumber;
        }
    }
}

