/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.ClassInfo;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.ConstantPoolInfo;
import edu.cmu.hcii.whyline.bytecode.FloatInfo;
import edu.cmu.hcii.whyline.bytecode.IntegerInfo;
import edu.cmu.hcii.whyline.bytecode.PushConstant;
import edu.cmu.hcii.whyline.bytecode.StringInfo;
import edu.cmu.hcii.whyline.trace.EventKind;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDC_W
extends PushConstant<Object> {
    private ConstantPoolInfo info;

    public LDC_W(CodeAttribute method, ConstantPoolInfo info) {
        super(method);
        this.info = info;
    }

    @Override
    public Object getConstant() {
        if (this.info instanceof IntegerInfo) {
            return ((IntegerInfo)this.info).getValue();
        }
        if (this.info instanceof FloatInfo) {
            return Float.valueOf(((FloatInfo)this.info).getValue());
        }
        if (this.info instanceof ClassInfo) {
            return ((ClassInfo)this.info).getName();
        }
        if (this.info instanceof StringInfo) {
            return ((StringInfo)this.info).getString();
        }
        return null;
    }

    @Override
    public final int getOpcode() {
        return 19;
    }

    @Override
    public int byteLength() {
        return 3;
    }

    @Override
    public void toBytes(DataOutputStream code) throws IOException {
        code.writeByte(this.getOpcode());
        code.writeShort(this.info.getIndexInConstantPool());
    }

    @Override
    public EventKind getTypeProduced() {
        if (this.info instanceof IntegerInfo) {
            return EventKind.CONSTANT_INTEGER_PRODUCED;
        }
        if (this.info instanceof FloatInfo) {
            return EventKind.CONSTANT_FLOAT_PRODUCED;
        }
        if (this.info instanceof ClassInfo) {
            return EventKind.OBJECT_PRODUCED;
        }
        if (this.info instanceof StringInfo) {
            return EventKind.OBJECT_PRODUCED;
        }
        throw new RuntimeException("Don't know how to get the type produced for a constant of type " + this.info.getClass());
    }

    @Override
    public String getReadableDescription() {
        return this.info.toString();
    }
}

