/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.Branch;
import edu.cmu.hcii.whyline.bytecode.Classfile;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.ExceptionHandler;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.INVOKESPECIAL;
import edu.cmu.hcii.whyline.bytecode.INVOKESTATIC;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.Opcodes;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.bytecode.UnconditionalBranch;
import edu.cmu.hcii.whyline.source.FileInterface;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.LineNumber;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.trace.EventKind;
import edu.cmu.hcii.whyline.trace.OperandStackType;
import edu.cmu.hcii.whyline.util.Named;
import edu.cmu.hcii.whyline.util.Util;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Instruction
implements Comparable<Instruction>,
Named {
    private static final int IS_IO = 0;
    private static final int REFERENCES_UNINITIALIZED_OBJECT = 1;
    private static final int REFERENCES_UNINITIALIZED_OBJECT_CHECKED = 2;
    private static final int REFERENCES_INSTANCE_BEFORE_SUPER = 3;
    private static final int REFERENCES_INSTANCE_BEFORE_SUPER_CHECKED = 4;
    private static final int PRODUCES_INSTANCE_FOR_INITIALIZER = 5;
    private static final int PRODUCES_INSTANCE_FOR_INITIALIZER_CHECKED = 6;
    protected final CodeAttribute code;
    private int instructionIndex;
    private int flags = 0;
    private static final int TO_STRING_CLASS_WIDTH = 20;
    private static final int TO_STRING_METHOD_WIDTH = 24;
    private static final int TO_STRING_INDEX_WIDTH = 6;
    private static final int TO_STRING_WHITESPACE = 8;
    private static final int TO_STRING_NUMBER_OF_CHARACTERS_BEFORE_INSTRUCTION_TYPE = 50;

    public Instruction(CodeAttribute code) {
        this.code = code;
    }

    private boolean getFlag(int flag) {
        return (this.flags & 1 << flag) != 0;
    }

    private void setFlag(int flag) {
        this.flags |= 1 << flag;
    }

    public boolean isIO() {
        return (this.flags & 1) != 0;
    }

    public void setIsIO() {
        this.setFlag(0);
        assert (this.isIO());
    }

    public boolean insertsDuplicatedOperandBelow() {
        return false;
    }

    public boolean duplicatesMultipleOperands() {
        return false;
    }

    public CodeAttribute getCode() {
        return this.code;
    }

    public MethodInfo getMethod() {
        return this.code.getMethod();
    }

    public Classfile getClassfile() {
        return this.code.getClassfile();
    }

    public FileInterface getFile() {
        Classfile classfile;
        FileInterface source = classfile = this.code.getMethod().getClassfile();
        if (classfile.getSourceFile() != null) {
            source = classfile.getSourceFile();
        }
        return source;
    }

    public LineNumber getLineNumber() {
        return this.code.getLineNumberFor(this);
    }

    public Line getLine() {
        LineNumber line = this.getLineNumber();
        if (line == null) {
            return null;
        }
        FileInterface file = this.getFile();
        if (file instanceof JavaSourceFile) {
            try {
                return file.getLine(line.getNumber());
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (file instanceof Classfile) {
            return this.getClassfile().getLine(this);
        }
        return null;
    }

    public void setInstructionIndex(int index) {
        this.instructionIndex = index;
    }

    public int getIndex() {
        return this.instructionIndex;
    }

    public int getByteIndex() {
        return this.code.getByteIndex(this.instructionIndex);
    }

    public Instruction getNext() {
        Instruction[] instructions = this.code.getInstructions();
        return this.instructionIndex < instructions.length - 1 ? instructions[this.instructionIndex + 1] : null;
    }

    public Instruction getPrevious() {
        return this.instructionIndex > 0 ? this.code.getInstructions()[this.instructionIndex - 1] : null;
    }

    public boolean isJumpedTo() {
        return this.code.getIncomingBranchesForInstruction(this.instructionIndex) != null;
    }

    public boolean couldJumpTo(Instruction inst) {
        return inst == this.getNext();
    }

    public Set<Instruction> getOrderedSuccessors() {
        return this.createSuccessorsCache();
    }

    public boolean nextInstructionIsOnlySuccessor() {
        return true;
    }

    protected SortedSet<Instruction> createSuccessorsCache() {
        TreeSet<Instruction> successors = new TreeSet<Instruction>();
        Instruction instructionAfter = this.getNext();
        if (instructionAfter != null) {
            successors.add(instructionAfter);
        }
        return successors;
    }

    public final SortedSet<Instruction> getOrderedPredecessors() {
        Instruction instructionBefore;
        TreeSet<Instruction> predecessors = new TreeSet<Instruction>();
        SortedSet<Branch> branches = this.code.getIncomingBranchesForInstruction(this.instructionIndex);
        if (branches != null) {
            predecessors.addAll(branches);
        }
        if ((instructionBefore = this.getPrevious()) != null && instructionBefore.couldJumpTo(this)) {
            predecessors.add(instructionBefore);
        }
        return predecessors;
    }

    public UnconditionalBranch getUnconditionalBranchPrecessessor() {
        HashSet<Instruction> toVisit = new HashSet<Instruction>();
        HashSet<Instruction> newToVisit = new HashSet<Instruction>();
        HashSet<Instruction> visited = new HashSet<Instruction>();
        toVisit.add(this);
        while (toVisit.size() > 0) {
            for (Instruction inst : toVisit) {
                visited.add(inst);
                for (Instruction pred : inst.getOrderedPredecessors()) {
                    if (pred == this) continue;
                    if (pred instanceof UnconditionalBranch) {
                        return (UnconditionalBranch)pred;
                    }
                    if (visited.contains(pred)) continue;
                    newToVisit.add(pred);
                }
            }
            toVisit.clear();
            HashSet<Instruction> temp = toVisit;
            toVisit = newToVisit;
            newToVisit = temp;
        }
        return null;
    }

    public Set<Instruction> getBranchDependencies() {
        return this.code.getControlDependenciesFor(this);
    }

    public Set<Branch> getIncomingBranches() {
        SortedSet<Branch> branches = this.code.getIncomingBranchesForInstruction(this.instructionIndex);
        return branches == null ? Collections.emptySet() : branches;
    }

    public boolean isLoop() {
        return false;
    }

    public boolean isLoopHeader() {
        for (Instruction predecessor : this.getOrderedPredecessors()) {
            if (!predecessor.isLoop()) continue;
            return true;
        }
        return false;
    }

    public final boolean canReachInMethod(Instruction instruction) {
        if (this.getCode() != instruction.getCode()) {
            return false;
        }
        HashSet<Instruction> visited = new HashSet<Instruction>();
        return this.canReachInMethodHelper(this, instruction, visited);
    }

    private final boolean canReachInMethodHelper(Instruction current, Instruction target, Set<Instruction> visited) {
        if (visited.contains(current)) {
            return false;
        }
        visited.add(current);
        for (Instruction successor : current.getOrderedSuccessors()) {
            if (successor != target && !this.canReachInMethodHelper(successor, target, visited)) continue;
            return true;
        }
        return false;
    }

    public boolean isInTryCatchBlock() {
        return this.code.isInstructionInTryCatchBlock(this);
    }

    public Set<ExceptionHandler> getExceptionHandlersProtecting() {
        return this.code.getExceptionHandlersProtecting(this);
    }

    public boolean isExceptionHandlerStart() {
        for (ExceptionHandler handler : this.code.getExceptionTable()) {
            if (handler.getHandlerPC() != this) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public abstract String getTypeDescriptorOfArgument(int var1);

    public StackDependencies.Producers getProducersOfArgument(int argument) {
        return this.code.getProducersOfArgument(this, argument);
    }

    public int getArgumentNumberOfProducer(Instruction inst) {
        int arg = 0;
        while (arg < this.getNumberOfArgumentProducers()) {
            StackDependencies.Producers producers = this.getProducersOfArgument(arg);
            int i = 0;
            while (i < producers.getNumberOfProducers()) {
                if (inst == producers.getProducer(i)) {
                    return arg;
                }
                ++i;
            }
            ++arg;
        }
        return -1;
    }

    public int getNumberOfArgumentProducers() {
        return Math.max(this.getNumberOfOperandsConsumed(), this.getNumberOfOperandsPeekedAt());
    }

    public StackDependencies.Consumers getConsumers() {
        return this.getCode().getConsumersOf(this);
    }

    public Instruction getFinalConsumer() {
        Instruction consumer = this;
        while (consumer != null) {
            StackDependencies.Consumers consumers = consumer.getConsumers();
            if (consumers.getNumberOfConsumers() > 0) {
                consumer = consumers.getFirstConsumer();
                continue;
            }
            return consumer;
        }
        return consumer;
    }

    public abstract int getOpcode();

    public abstract int byteLength();

    public abstract int getNumberOfOperandsConsumed();

    public abstract int getNumberOfOperandsProduced();

    public abstract int getNumberOfOperandsPeekedAt();

    public boolean hasVariableExecution() {
        return Opcodes.EXECUTION_IS_VARIABLE[this.getOpcode()];
    }

    public final boolean referencesUninitializedObject() {
        if (!this.getFlag(2)) {
            this.setFlag(2);
            boolean isTrue = false;
            isTrue = this.getNumberOfOperandsProduced() == 0 ? false : (this.producesInstanceForInstanceInitializer() ? true : this.referencesInstanceInInitializerBeforeSuperInitializer());
            if (isTrue) {
                this.setFlag(1);
            }
        }
        return this.getFlag(1);
    }

    public final boolean producesInstanceForInstanceInitializer() {
        if (!this.getFlag(6)) {
            this.setFlag(6);
            Instruction consumer = this.getConsumers().getFirstConsumer();
            if (consumer instanceof INVOKESPECIAL && ((INVOKESPECIAL)consumer).getMethodInvoked().callsInstanceInitializer() && consumer.getProducersOfArgument(0).getFirstProducer() == this) {
                this.setFlag(5);
            }
        }
        return this.getFlag(5);
    }

    public final boolean referencesInstanceInInitializerBeforeSuperInitializer() {
        if (!this.getFlag(4)) {
            this.setFlag(4);
            if (this instanceof GetLocal && this.getMethod().isInstanceInitializer() && ((GetLocal)this).getLocalID() == 0 && this.getCode().getCallToInitializer().getIndex() >= this.getIndex()) {
                this.setFlag(3);
            }
        }
        return this.getFlag(3);
    }

    public abstract EventKind getTypeProduced();

    public OperandStackType getStackTypeProduced() {
        return this.getTypeProduced().getStackType();
    }

    public abstract void toBytes(DataOutputStream var1) throws IOException;

    private boolean isInstrumentation() {
        return this instanceof INVOKESTATIC && ((INVOKESTATIC)this).getMethodInvoked().getClassName().getText().equals("edu/cmu/hcii/whyline/tracing/Tracer");
    }

    public String toString() {
        boolean consumedByInstrumentation = this.isInstrumentation();
        for (Instruction consumer : this.getConsumers()) {
            if (!consumer.isInstrumentation()) continue;
            consumedByInstrumentation = true;
        }
        String methodString = Instruction.getMethodString(this.getMethod());
        String index = Util.fillOrTruncateString((consumedByInstrumentation ? "* " : "  ") + this.getIndex(), 6);
        String instructionTypeName = Util.fillOrTruncateString(this.getClass().getSimpleName().toLowerCase(), 12);
        String result = String.valueOf(methodString) + " " + index + " " + instructionTypeName;
        return result;
    }

    public static String getMethodString(MethodInfo method) {
        String methodName = method.getInternalName();
        String className = Util.fillOrTruncateString(method.getClassfile().getSimpleName(), 20);
        methodName = Util.fillOrTruncateString(methodName, 24);
        String context = ":::";
        return String.valueOf(context) + " " + className + " " + methodName;
    }

    public abstract String getAssociatedName();

    public String toStringStartingWithInstructionType() {
        return this.toString().substring(58);
    }

    public abstract String getReadableDescription();

    @Override
    public String getDisplayName(boolean html, int limit) {
        return this.getReadableDescription();
    }

    @Override
    public int compareTo(Instruction i) {
        return this.instructionIndex - i.instructionIndex;
    }

    public int hashCode() {
        return 2 * super.hashCode() + this.instructionIndex;
    }
}

