/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.Attribute;
import edu.cmu.hcii.whyline.bytecode.ClassInfo;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class InnerClassesAttribute
extends Attribute {
    private final ConstantPool pool;
    private final UTF8Info attributeName;
    private final List<InnerClass> classes = new ArrayList<InnerClass>();

    public InnerClassesAttribute(UTF8Info attributeName, ConstantPool pool, DataInputStream data, int length) throws IOException {
        this.pool = pool;
        this.attributeName = attributeName;
        int numberOfClasses = data.readUnsignedShort();
        int i = 0;
        while (i < numberOfClasses) {
            int innerClassInfoIndex = data.readUnsignedShort();
            int outerClassInfoIndex = data.readUnsignedShort();
            int innerNameIndex = data.readUnsignedShort();
            int innerClassAccessFlags = data.readUnsignedShort();
            this.classes.add(new InnerClass((ClassInfo)pool.get(innerClassInfoIndex), (ClassInfo)(outerClassInfoIndex == 0 ? null : pool.get(outerClassInfoIndex)), (UTF8Info)(innerNameIndex == 0 ? null : pool.get(innerNameIndex)), innerClassAccessFlags));
            ++i;
        }
    }

    public int getFlagsFor(QualifiedClassName name) {
        for (InnerClass c : this.classes) {
            if (c.definition == null || c.definition.getName() != name) continue;
            return c.flags;
        }
        return -1;
    }

    public void toBytes(DataOutputStream stream) throws IOException {
        stream.writeShort(this.attributeName.getIndexInConstantPool());
        stream.writeInt(this.getAttributeLengthWithoutNameAndLength());
        stream.writeShort(this.classes.size());
        for (InnerClass c : this.classes) {
            stream.writeShort(c.definition.getIndexInConstantPool());
            stream.writeShort(c.outerClass == null ? 0 : c.outerClass.getIndexInConstantPool());
            stream.writeShort(c.name == null ? 0 : c.name.getIndexInConstantPool());
            stream.writeShort(c.flags);
        }
    }

    public int getTotalAttributeLength() {
        return 8 + this.classes.size() * 8;
    }

    public class InnerClass {
        final ClassInfo definition;
        final ClassInfo outerClass;
        final UTF8Info name;
        final int flags;

        public InnerClass(ClassInfo classInfo, ClassInfo outerClass, UTF8Info name, int flags) {
            this.definition = classInfo;
            this.outerClass = outerClass;
            this.name = name;
            this.flags = flags;
        }
    }
}

