/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.Attribute;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.INVOKEVIRTUAL;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.JavaSpecificationViolation;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import edu.cmu.hcii.whyline.io.CreateGraphicsParser;
import edu.cmu.hcii.whyline.io.GetGraphicsParser;
import edu.cmu.hcii.whyline.io.GraphicalOutputParser;
import edu.cmu.hcii.whyline.io.TextualOutputParser;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.tracing.Agent;
import edu.cmu.hcii.whyline.tracing.ClassIDs;
import edu.cmu.hcii.whyline.util.IntegerVector;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class IOAttribute
extends Attribute {
    public static final String NAME = "InputOutput";
    private UTF8Info attributeName;
    private ConstantPool pool;
    private IntegerVector ids;

    public IOAttribute(UTF8Info name, ConstantPool pool, DataInputStream data, int length) throws IOException {
        this.attributeName = name;
        this.pool = pool;
        int numberOfIOInstructions = data.readInt();
        this.ids = new IntegerVector(numberOfIOInstructions);
        int i = 0;
        while (i < numberOfIOInstructions) {
            int instructionID = data.readInt();
            this.ids.append(instructionID);
            Instruction ioInstruction = pool.getClassfile().getInstructionByID(instructionID);
            ioInstruction.setIsIO();
            ++i;
        }
    }

    public IOAttribute(ConstantPool pool) throws JavaSpecificationViolation {
        this.pool = pool;
        this.attributeName = pool.addUTF8Info(NAME);
        this.ids = new IntegerVector(100);
        Trace trace = pool.getClassfile().getTrace();
        ClassIDs classIDs = trace == null ? Agent.classIDs : trace.getClassIDs();
        int instructionID = 0;
        for (MethodInfo method : pool.getClassfile().getDeclaredMethods()) {
            CodeAttribute code = method.getCode();
            if (code == null) continue;
            boolean invokesTextualOutput = code.invokesTextualOutput();
            Instruction[] instructionArray = code.getInstructions();
            int n = instructionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Instruction inst = instructionArray[n2];
                boolean isIO = false;
                if (inst.getIndex() == 0 && inst.getMethod().getClassfile().getInternalName().equals(QualifiedClassName.get("java/awt/LightweightDispatcher")) && method.getInternalName().equals("retargetMouseEvent")) {
                    isIO = true;
                } else if (inst instanceof INVOKEVIRTUAL && GraphicalOutputParser.handles(inst)) {
                    isIO = true;
                } else if (GetGraphicsParser.handles(inst)) {
                    isIO = true;
                } else if (CreateGraphicsParser.handles(inst)) {
                    isIO = true;
                } else if (invokesTextualOutput && TextualOutputParser.handles(classIDs, inst)) {
                    isIO = true;
                }
                if (isIO) {
                    this.ids.append(instructionID);
                    inst.setIsIO();
                }
                ++instructionID;
                ++n2;
            }
        }
    }

    public void toBytes(DataOutputStream bytes) throws IOException {
        bytes.writeShort(this.attributeName.getIndexInConstantPool());
        bytes.writeInt(this.ids.size() * 4 + 4);
        bytes.writeInt(this.ids.size());
        int i = 0;
        while (i < this.ids.size()) {
            bytes.writeInt(this.ids.get(i));
            ++i;
        }
    }

    public int getTotalAttributeLength() {
        return 10 + this.ids.size() * 4;
    }
}

