/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.ClassInfo;
import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.ConstantPoolInfo;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.NameAndTypeInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class FieldrefInfo
extends ConstantPoolInfo {
    public static final int tag = 9;
    private int classInfoIndex;
    private int nameAndTypeIndex;
    private ClassInfo classInfo;
    private NameAndTypeInfo nameAndTypeInfo;

    public FieldrefInfo(ConstantPool pool, DataInputStream in) throws IOException {
        super(pool);
        this.classInfoIndex = in.readUnsignedShort();
        this.nameAndTypeIndex = in.readUnsignedShort();
    }

    public void resolveDependencies() {
        this.classInfo = (ClassInfo)this.pool.get(this.classInfoIndex);
        this.nameAndTypeInfo = (NameAndTypeInfo)this.pool.get(this.nameAndTypeIndex);
    }

    public void toBytes(DataOutputStream bytes) throws IOException {
        bytes.writeByte(9);
        bytes.writeShort(this.classInfo.getIndexInConstantPool());
        bytes.writeShort(this.nameAndTypeInfo.getIndexInConstantPool());
    }

    public String getQualifiedName() {
        return this.getClassname() + "." + this.getName();
    }

    public QualifiedClassName getClassname() {
        return this.classInfo.getName();
    }

    public String getName() {
        return this.nameAndTypeInfo.getName();
    }

    public String getTypeDescriptor() {
        return this.nameAndTypeInfo.getTypeDescriptor();
    }

    public boolean matches(FieldInfo field) {
        return field.getQualifiedName().equals(this.getQualifiedName());
    }

    public boolean matchesClassNameAndDescriptor(QualifiedClassName classname, String name, String descriptor) {
        return this.getClassname().equals(classname) && this.getName().equals(name) && this.getTypeDescriptor().equals(descriptor);
    }

    public String toString() {
        return this.getClassname() + "." + this.getName();
    }

    public boolean equals(Object o) {
        return o instanceof FieldrefInfo && ((FieldrefInfo)o).classInfo.equals(this.classInfo) && ((FieldrefInfo)o).nameAndTypeInfo.equals(this.nameAndTypeInfo);
    }
}

