/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.bytecode.ConstantPool;
import edu.cmu.hcii.whyline.bytecode.ConstantPoolInfo;
import edu.cmu.hcii.whyline.bytecode.QualifiedClassName;
import edu.cmu.hcii.whyline.bytecode.UTF8Info;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ClassInfo
extends ConstantPoolInfo {
    public static final int tag = 7;
    private int indexOfName;
    private UTF8Info name;
    private QualifiedClassName qualifiedName;

    public ClassInfo(ConstantPool pool, DataInputStream in) throws IOException {
        super(pool);
        this.indexOfName = in.readUnsignedShort();
    }

    public ClassInfo(ConstantPool pool, UTF8Info name) {
        super(pool);
        this.name = name;
    }

    public void resolveDependencies() {
        this.name = (UTF8Info)this.pool.get(this.indexOfName);
    }

    public void toBytes(DataOutputStream bytes) throws IOException {
        bytes.writeByte(7);
        bytes.writeShort(this.name.getIndexInConstantPool());
    }

    public QualifiedClassName getName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = QualifiedClassName.get(this.name.toString());
        }
        return this.qualifiedName;
    }

    public String getSimpleName() {
        return this.getName().getSimpleName();
    }

    public String toString() {
        return String.valueOf(this.getName().toString()) + ".class";
    }

    public boolean equals(Object o) {
        return o instanceof ClassInfo && ((ClassInfo)o).name.equals(this.name);
    }
}

