/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.bytecode;

import edu.cmu.hcii.whyline.analysis.AnalysisException;
import edu.cmu.hcii.whyline.analysis.LoopPath;
import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Branch
extends Instruction {
    private List<LoopPath> paths;
    protected LoopAnalysisState isLoop = LoopAnalysisState.UNKNOWN;

    public Branch(CodeAttribute method) {
        super(method);
    }

    public abstract boolean isConditional();

    public abstract Instruction getTarget();

    public abstract void resolveTargets(Instruction[] var1) throws AnalysisException;

    @Override
    public abstract SortedSet<Instruction> createSuccessorsCache();

    @Override
    public final boolean nextInstructionIsOnlySuccessor() {
        return false;
    }

    public abstract void replaceTarget(Instruction var1, Instruction var2);

    @Override
    public final boolean isLoop() {
        if (this.isLoop == LoopAnalysisState.UNKNOWN) {
            boolean isLoopFlag = this.determineIfLoop();
            this.isLoop = isLoopFlag ? LoopAnalysisState.YES : LoopAnalysisState.NO;
        }
        return this.isLoop == LoopAnalysisState.YES;
    }

    protected abstract boolean determineIfLoop();

    public final Instruction getSuccessorAfterLoop() {
        for (Instruction successor : this.getOrderedSuccessors()) {
            if (successor.getIndex() <= this.getIndex()) continue;
            return successor;
        }
        return null;
    }

    public List<LoopPath> getLoopPaths() {
        if (this.isLoop() && this.paths == null) {
            this.paths = Branch.generatePaths(this);
        }
        return this.paths == null ? Collections.emptyList() : Collections.unmodifiableList(this.paths);
    }

    private static Vector<LoopPath> generatePaths(Branch loop) {
        HashSet<Instruction> visited = new HashSet<Instruction>(20);
        LoopPath currentPath = new LoopPath();
        Vector<LoopPath> paths = new Vector<LoopPath>();
        Instruction instructionAfterLoop = loop.getSuccessorAfterLoop();
        Branch.generatePaths(instructionAfterLoop, loop, currentPath, visited, paths);
        return paths;
    }

    private static void generatePaths(Instruction afterLoop, Instruction inst, LoopPath currentPath, Set<Instruction> visited, Vector<LoopPath> paths) {
        if (inst == afterLoop || visited.contains(inst)) {
            paths.add(currentPath);
            return;
        }
        visited.add(inst);
        for (Instruction successor : inst.getOrderedSuccessors()) {
            LoopPath path;
            path = inst instanceof Branch ? (path = new LoopPath(currentPath, (Branch)inst, successor)) : currentPath;
            Branch.generatePaths(afterLoop, successor, path, visited, paths);
        }
    }

    public abstract String getKeyword();

    @Override
    public String getAssociatedName() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LoopAnalysisState {
        UNKNOWN,
        YES,
        NO;

    }
}

