/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.qa.ExpectedObject;
import edu.cmu.hcii.whyline.qa.Question;
import edu.cmu.hcii.whyline.qa.UnexecutedAnswer;
import edu.cmu.hcii.whyline.qa.UnexecutedInstruction;
import edu.cmu.hcii.whyline.trace.Trace;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnexecutedInstructionAnalyzer {
    private final Trace trace;
    private final Instruction[] unexecuted;
    private final Question<?> question;
    private final ExpectedObject objectExpectation;
    private final Set<UnexecutedInstruction> checked = new HashSet<UnexecutedInstruction>();
    private final Set<UnexecutedInstruction> instructionsToAdd = new HashSet<UnexecutedInstruction>();
    private final List<UnexecutedInstruction> instructionsToAnalyze = new Vector<UnexecutedInstruction>();
    private boolean DEBUG = false;

    private UnexecutedInstructionAnalyzer(Question<?> question, Instruction[] unexecuted, ExpectedObject expectation) {
        this.trace = question.getTrace();
        this.unexecuted = unexecuted;
        this.question = question;
        this.objectExpectation = expectation;
    }

    public static UnexecutedAnswer explain(Question<?> question, Instruction[] unexecuted, ExpectedObject expectation) {
        UnexecutedInstructionAnalyzer analyzer = new UnexecutedInstructionAnalyzer(question, unexecuted, expectation);
        return analyzer.explain();
    }

    private UnexecutedAnswer explain() {
        this.instructionsToAnalyze.clear();
        this.instructionsToAdd.clear();
        UnexecutedInstruction[] unexecutedInstructions = new UnexecutedInstruction[this.unexecuted.length];
        int i = 0;
        Instruction[] instructionArray = this.unexecuted;
        int n = this.unexecuted.length;
        int n2 = 0;
        while (n2 < n) {
            Instruction un = instructionArray[n2];
            UnexecutedInstruction unInst = this.question.getUnexecutedInstruction(un, this.objectExpectation);
            unexecutedInstructions[i++] = unInst;
            this.instructionsToAnalyze.add(unInst);
            ++n2;
        }
        while (this.instructionsToAnalyze.size() > 0) {
            boolean foundFamiliar = false;
            for (UnexecutedInstruction ine : this.instructionsToAnalyze) {
                if (this.checked.contains(ine)) continue;
                foundFamiliar = this.trace.classIsReferencedInFamiliarSourceFile(ine.getInstruction().getClassfile().getInternalName());
                this.checked.add(ine);
                ine.explain();
                assert (ine.getReason() != null) : "There must be a reason why " + ine.getInstruction() + " didn't execute.";
                this.instructionsToAdd.addAll(ine.getIncoming());
            }
            this.instructionsToAnalyze.clear();
            this.instructionsToAnalyze.addAll(this.instructionsToAdd);
            this.instructionsToAdd.clear();
            if (foundFamiliar) break;
        }
        return new UnexecutedAnswer(this.question, unexecutedInstructions);
    }

    private void debug(String message, int depth) {
        if (!this.DEBUG) {
            return;
        }
        int i = 0;
        while (i < depth) {
            System.out.print("  ");
            ++i;
        }
        System.out.println(message);
    }
}

