/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.analysis.SearchResultsInterface;
import edu.cmu.hcii.whyline.source.JavaSourceFile;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.ParseException;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.trace.JDKSource;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import edu.cmu.hcii.whyline.util.IntegerVector;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSearch
implements SearchResultsInterface {
    private final String query;
    private final Mode mode;
    private final WhylineUI whylineUI;
    private boolean done = false;
    private int filesRemaining;
    private final Set<Token> matches = new HashSet<Token>();

    public TextSearch(WhylineUI whyUI, String queryText, Mode searchMode) {
        this.whylineUI = whyUI;
        this.query = queryText.toLowerCase(Locale.ENGLISH);
        this.mode = searchMode;
        this.filesRemaining = this.whylineUI.getTrace().getNumberOfUserSourceFiles();
        if (this.mode == Mode.ALL) {
            this.filesRemaining += JDKSource.getNumberOfSourceFilesKnown();
        }
        Thread search = new Thread(){

            public void run() {
                for (JavaSourceFile source : TextSearch.this.whylineUI.getTrace().getAllSourceFiles()) {
                    this.check(source);
                }
                if (TextSearch.this.mode == Mode.ALL) {
                    for (JavaSourceFile source : JDKSource.getAllSource()) {
                        this.check(source);
                    }
                }
                TextSearch.this.done = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void check(JavaSourceFile source) {
                Set set = TextSearch.this.matches;
                synchronized (set) {
                    try {
                        String string = source.getSourceAsString();
                        String lower = string.toLowerCase(Locale.ENGLISH);
                        IntegerVector matchIndices = new IntegerVector(3);
                        int index = 0;
                        while (index >= 0) {
                            index = lower.indexOf(TextSearch.this.query, index);
                            if (index <= 0) continue;
                            matchIndices.append(index);
                            ++index;
                        }
                        Line[] lines = source.getLines();
                        if (lines != null) {
                            int charIndex = 0;
                            Line[] lineArray = lines;
                            int n = lines.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Line line = lineArray[n2];
                                for (Token token : line.getTokens()) {
                                    int i = 0;
                                    while (i < matchIndices.size()) {
                                        int matchIndex = matchIndices.get(i);
                                        if (matchIndex >= charIndex && matchIndex <= charIndex + token.getText().length()) {
                                            TextSearch.this.matches.add(token);
                                        }
                                        ++i;
                                    }
                                    charIndex += token.getText().length();
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    TextSearch textSearch = TextSearch.this;
                    textSearch.filesRemaining = textSearch.filesRemaining - 1;
                }
            }
        };
        search.start();
    }

    @Override
    public String getResultsDescription() {
        return "text search for \"" + this.query + "\"";
    }

    @Override
    public String getCurrentStatus() {
        return this.filesRemaining <= 0 ? "Done searching." : this.filesRemaining + " files left to search.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSet<Token> getResults() {
        Set<Token> set = this.matches;
        synchronized (set) {
            return new TreeSet<Token>(this.matches);
        }
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        FILES("search my source"),
        ALL("search everything");

        public final String label;

        private Mode(String name) {
            this.label = name;
        }

        public String toString() {
            return this.label;
        }
    }
}

