/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.analysis.SearchResultsInterface;
import edu.cmu.hcii.whyline.bytecode.Definition;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.Use;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldUsesSearch
implements SearchResultsInterface {
    private final WhylineUI whylineUI;
    private final FieldInfo field;

    public FieldUsesSearch(WhylineUI whylineUI, FieldInfo field) {
        this.whylineUI = whylineUI;
        this.field = field;
    }

    @Override
    public String getCurrentStatus() {
        return "Done.";
    }

    @Override
    public SortedSet<Token> getResults() {
        TreeSet<Token> lines = new TreeSet<Token>();
        List<Use> uses = this.field.getUses();
        for (Use use : uses) {
            if (use.getLine() == null) continue;
            lines.addAll(use.getLine().getTokensAfterFirstNonWhitespaceToken());
        }
        List<Definition> defs = this.field.getDefinitions();
        for (Definition def : defs) {
            lines.addAll(def.getLine().getTokensAfterFirstNonWhitespaceToken());
        }
        return lines;
    }

    @Override
    public String getResultsDescription() {
        return "uses of " + this.field.getDisplayName(true, -1);
    }

    @Override
    public boolean isDone() {
        return true;
    }
}

