/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.analysis.SearchResultsInterface;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.source.Line;
import edu.cmu.hcii.whyline.source.Token;
import edu.cmu.hcii.whyline.trace.Trace;
import edu.cmu.hcii.whyline.trace.TraceValue;
import edu.cmu.hcii.whyline.trace.Value;
import edu.cmu.hcii.whyline.ui.WhylineUI;
import gnu.trove.TIntHashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DynamicSlice
implements SearchResultsInterface {
    private final Trace trace;
    private final WhylineUI whylineUI;
    private final Line criterion;
    private final boolean onlyMostRecent;
    private final Slicer slicer;
    private final int earliestEventIDSliced;
    private final TIntHashSet eventsSliced;

    public DynamicSlice(WhylineUI whylineUI, Line line, boolean onlyMostRecent) {
        this.whylineUI = whylineUI;
        this.trace = whylineUI.getTrace();
        this.criterion = line;
        this.onlyMostRecent = onlyMostRecent;
        this.eventsSliced = new TIntHashSet();
        int smallestID = Integer.MAX_VALUE;
        for (Instruction inst : this.criterion.getInstructions()) {
            int recentExecution = this.trace.getNumberOfEvents();
            do {
                if ((recentExecution = whylineUI.getTrace().findExecutionOfInstructionPriorTo(inst, recentExecution)) < 0) continue;
                this.eventsSliced.add(recentExecution);
                if (recentExecution >= smallestID) continue;
                smallestID = recentExecution;
            } while (recentExecution >= 0);
        }
        this.earliestEventIDSliced = smallestID;
        this.slicer = new Slicer(this.eventsSliced);
        this.slicer.start();
    }

    @Override
    public String getResultsDescription() {
        return "slice on " + this.criterion.getFile().getShortFileName() + ":" + this.criterion.getLineNumber().getNumber();
    }

    @Override
    public String getCurrentStatus() {
        if (this.slicer.done) {
            return this.slicer.slice.isEmpty() ? "Slice is empty." : "Done.";
        }
        return this.slicer.eventsToExplain.size() + " events left to explain...";
    }

    @Override
    public SortedSet<Token> getResults() {
        return this.slicer.slice;
    }

    @Override
    public boolean isDone() {
        return this.slicer.done;
    }

    public int getEventIDSliced() {
        return this.earliestEventIDSliced;
    }

    private class Slicer
    extends Thread {
        public final SortedSet<Token> slice = new TreeSet<Token>();
        public final TIntHashSet eventsToExplain;
        public boolean done = false;

        private Slicer(TIntHashSet eventsToExplain) {
            this.eventsToExplain = new TIntHashSet(eventsToExplain.toArray());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TIntHashSet newEvents = new TIntHashSet();
            while (this.eventsToExplain.size() > 0) {
                TIntHashSet tIntHashSet = this.eventsToExplain;
                synchronized (tIntHashSet) {
                    int[] nArray = this.eventsToExplain.toArray();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int event = nArray[n2];
                        this.slice.addAll(DynamicSlice.this.trace.getInstruction(event).getLine().getTokensAfterFirstNonWhitespaceToken());
                        List<Value> sd = DynamicSlice.this.trace.getOperandStackDependencies(event);
                        int md = DynamicSlice.this.trace.getHeapDependency(event);
                        if (md >= 0) {
                            newEvents.add(md);
                        }
                        for (Value value : sd) {
                            if (!(value instanceof TraceValue)) continue;
                            newEvents.add(((TraceValue)value).getEventID());
                        }
                        ++n2;
                    }
                    this.eventsToExplain.clear();
                    this.eventsToExplain.addAll(newEvents.toArray());
                    newEvents.clear();
                }
            }
            this.done = true;
        }
    }
}

