/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.bytecode.CodeAttribute;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ControlDependencies {
    private final CodeAttribute code;
    private final TIntObjectHashMap<Set<Instruction>> controlDependenciesByInstructionIndex;

    public ControlDependencies(CodeAttribute code) {
        this.code = code;
        this.controlDependenciesByInstructionIndex = new TIntObjectHashMap(code.getNumberOfInstructions() / 2);
        Instruction last = code.getInstruction(code.getNumberOfInstructions() - 1);
        ArrayList<Instruction> instructionsInPostOrderTraversalOfReverseControlFlowGraph = new ArrayList<Instruction>(code.getNumberOfInstructions());
        TObjectIntHashMap<Instruction> postOrderNumbers = this.visitPostOrderIterative(last, instructionsInPostOrderTraversalOfReverseControlFlowGraph);
        Instruction[] immediatePostDominators = this.determinePostDominanceFrontiers(postOrderNumbers, instructionsInPostOrderTraversalOfReverseControlFlowGraph);
        this.addControlDependencies(immediatePostDominators);
    }

    public Set<Instruction> getControlDependenciesOf(Instruction inst) {
        Set<Instruction> controlDependencies = this.controlDependenciesByInstructionIndex.get(inst.getIndex());
        return controlDependencies == null ? Collections.emptySet() : controlDependencies;
    }

    private TObjectIntHashMap<Instruction> visitPostOrderIterative(Instruction start, ArrayList<Instruction> instructionsInPostOrderTraversalOfReverseControlFlowGraph) {
        TObjectIntHashMap<Instruction> postOrderNumbers = new TObjectIntHashMap<Instruction>();
        ArrayList<Instruction> stack = new ArrayList<Instruction>();
        TIntHashSet visitedIndices = new TIntHashSet(this.code.getNumberOfInstructions());
        TIntHashSet processedIndices = new TIntHashSet(this.code.getNumberOfInstructions());
        stack.add(start);
        while (stack.size() > 0) {
            Instruction top = (Instruction)stack.get(stack.size() - 1);
            if (visitedIndices.contains(top.getIndex())) {
                stack.remove(stack.size() - 1);
                if (processedIndices.contains(top.getIndex())) continue;
                processedIndices.add(top.getIndex());
                instructionsInPostOrderTraversalOfReverseControlFlowGraph.add(0, top);
                postOrderNumbers.put(top, instructionsInPostOrderTraversalOfReverseControlFlowGraph.size());
                continue;
            }
            visitedIndices.add(top.getIndex());
            int insertionIndex = 0;
            for (Instruction predecessor : top.getOrderedPredecessors()) {
                if (visitedIndices.contains(predecessor.getIndex())) continue;
                stack.add(stack.size() - insertionIndex, predecessor);
                ++insertionIndex;
            }
        }
        return postOrderNumbers;
    }

    /*
     * Unable to fully structure code
     */
    private Instruction[] determinePostDominanceFrontiers(TObjectIntHashMap<Instruction> postOrderNumbers, ArrayList<Instruction> instructionsInPostOrderTraversalOfReverseControlFlowGraph) {
        immediatePostDominators = new Instruction[this.code.getNumberOfInstructions()];
        postDominatorIsSet = new boolean[this.code.getNumberOfInstructions()];
        changed = true;
        while (changed) {
            changed = false;
            for (Instruction currentInstruction : instructionsInPostOrderTraversalOfReverseControlFlowGraph) {
                successors = currentInstruction.getOrderedSuccessors();
                if (successors.isEmpty()) {
                    postDominatorIsSet[currentInstruction.getIndex()] = true;
                    continue;
                }
                succIterator = successors.iterator();
                newImmediatePostDominator = succIterator.next();
                while (succIterator.hasNext()) {
                    successor = succIterator.next();
                    if (!postDominatorIsSet[successor.getIndex()]) continue;
                    finger1 = successor;
                    finger2 = newImmediatePostDominator;
                    ** GOTO lbl25
                    {
                        finger1 = immediatePostDominators[finger1.getIndex()];
                        do {
                            if (finger1 != null && finger2 != null && postOrderNumbers.get(finger1) < postOrderNumbers.get(finger2)) continue block3;
                            while (finger1 != null && finger2 != null && postOrderNumbers.get(finger2) < postOrderNumbers.get(finger1)) {
                                finger2 = immediatePostDominators[finger2.getIndex()];
                            }
lbl25:
                            // 2 sources

                        } while (finger1 != null && finger2 != null && finger1 != finger2);
                    }
                    newImmediatePostDominator = finger1;
                }
                if (immediatePostDominators[currentInstruction.getIndex()] == newImmediatePostDominator) continue;
                immediatePostDominators[currentInstruction.getIndex()] = newImmediatePostDominator;
                postDominatorIsSet[currentInstruction.getIndex()] = true;
                changed = true;
            }
        }
        return immediatePostDominators;
    }

    private void addControlDependencies(Instruction[] immediatePostDominators) {
        Instruction[] instructionArray = this.code.getInstructions();
        int n = instructionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Instruction branch = instructionArray[n2];
            Set<Instruction> successors = branch.getOrderedSuccessors();
            if (successors.size() >= 2) {
                Iterator<Instruction> iterator = successors.iterator();
                block1: while (iterator.hasNext()) {
                    Instruction successor;
                    Instruction runner = successor = iterator.next();
                    while (runner != null && runner != immediatePostDominators[branch.getIndex()]) {
                        boolean wasNew = this.addControlDependency(runner, branch, successor);
                        runner = immediatePostDominators[runner.getIndex()];
                        if (!wasNew) continue block1;
                    }
                }
            }
            ++n2;
        }
    }

    private boolean addControlDependency(Instruction inst, Instruction dependency, Instruction target) {
        Set<Instruction> dependencies = this.controlDependenciesByInstructionIndex.get(inst.getIndex());
        if (dependencies == null) {
            dependencies = new HashSet<Instruction>(1);
            this.controlDependenciesByInstructionIndex.put(inst.getIndex(), dependencies);
        }
        return dependencies.add(dependency);
    }
}

