/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.whyline.analysis;

import edu.cmu.hcii.whyline.bytecode.AbstractReturn;
import edu.cmu.hcii.whyline.bytecode.Definition;
import edu.cmu.hcii.whyline.bytecode.FieldInfo;
import edu.cmu.hcii.whyline.bytecode.GETFIELD;
import edu.cmu.hcii.whyline.bytecode.GETSTATIC;
import edu.cmu.hcii.whyline.bytecode.GetLocal;
import edu.cmu.hcii.whyline.bytecode.Instruction;
import edu.cmu.hcii.whyline.bytecode.Invoke;
import edu.cmu.hcii.whyline.bytecode.MethodInfo;
import edu.cmu.hcii.whyline.bytecode.SetLocal;
import edu.cmu.hcii.whyline.bytecode.StackDependencies;
import edu.cmu.hcii.whyline.bytecode.Use;
import edu.cmu.hcii.whyline.trace.Trace;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlackBoxDependencies {
    private final Set<Use> dependencies;
    private final Set<Instruction> visited;
    private final Invoke invoke;
    private final Trace trace;

    private BlackBoxDependencies(Trace trace, Invoke invoke) {
        this.trace = trace;
        this.invoke = invoke;
        this.dependencies = new HashSet<Use>();
        this.visited = new HashSet<Instruction>();
        this.analyze();
    }

    public static Set<Use> get(Trace trace, Invoke invoke) {
        return new BlackBoxDependencies((Trace)trace, (Invoke)invoke).dependencies;
    }

    private void analyze() {
        MethodInfo[] methods;
        MethodInfo[] methodInfoArray = methods = this.trace.getMethodsFromReference(this.invoke);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodInfo method = methodInfoArray[n2];
            this.process(method);
            ++n2;
        }
    }

    private void process(MethodInfo method) {
        for (AbstractReturn ret : method.getReturns()) {
            this.process(ret);
        }
    }

    private void process(Instruction producer) {
        if (this.visited.contains(producer)) {
            return;
        }
        this.visited.add(producer);
        if (producer instanceof GETSTATIC) {
            this.dependencies.add((GETSTATIC)producer);
        } else if (producer instanceof GetLocal) {
            int localID = ((GetLocal)producer).getLocalID();
            int arg = producer.getMethod().getArgumentNumberOfLocalID(localID);
            if (arg < producer.getMethod().getNumberOfArguments()) {
                this.dependencies.add((GetLocal)producer);
            } else {
                for (SetLocal set : producer.getCode().getLocalDependencies().getPotentialDefinitionsOfLocalIDBefore(producer, localID)) {
                    this.process(set);
                }
            }
        } else if (producer instanceof GETFIELD) {
            FieldInfo field = producer.getClassfile().getFieldByName(((GETFIELD)producer).getFieldref().getName());
            for (Definition def : field.getDefinitions()) {
                this.process(def);
            }
        } else {
            int arg = 0;
            while (arg < producer.getNumberOfArgumentProducers()) {
                StackDependencies.Producers producers = producer.getProducersOfArgument(arg);
                Instruction[] instructionArray = producers.getProducers();
                int n = instructionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Instruction p = instructionArray[n2];
                    this.process(p);
                    ++n2;
                }
                ++arg;
            }
        }
    }
}

