#!/bin/bash

CBMCLOC=./cbmc

echo "$(tput setaf 1)[15-414] Bug Catching: Automated Program Verification$(tput sgr 0)"
echo "$(tput setaf 1)[15-414] CBMC: Bounded Model Checking for C$(tput sgr 0)"

if [ "$#" -le 1 ]; then
    echo "Usage: ./cbmc.sh function_name unwind_depth output_file"
    echo "       function_name = name of the function to analyze"
    echo "       unwind_depth  = number of times each loop is unwind"
    echo "       output_file (optional) = save output of CBMC to this file"
fi

if [ "$#" -eq 2 ]; then
	echo "$(tput setaf 4)[15-414] Running command: $(tput setaf 2)$CBMCLOC ubarray.c --function $1 --unwind $2 --unwinding-assertions --pointer-check --trace --slice-formula --drop-unused-functions$(tput sgr 0)"
	$CBMCLOC ubarray.c --function $1 --unwind $2 --unwinding-assertions --pointer-check --trace --slice-formula --drop-unused-functions
fi

if [ "$#" -eq 3 ]; then
	echo "$(tput setaf 4)[15-414] Saving output to: $(tput setaf 2)$3$(tput sgr 0)"
	$CBMCLOC ubarray.c --function $1 --unwind $2 --unwinding-assertions --pointer-check --trace --slice-formula --drop-unused-functions > $3
fi
