# Instructions for building and testing

Below you will find instructions for compiling and running
your code for Problem 2, "Checkable Certificates".

You will find an example test case in the `test0` function
in `bfs.mlw`. The file `main.ml` is configured to run
this test case, and print the result to standard output.
This test case:
	* Calls `trivial ()` to construct a simple graph
	  containing two vertices and one edge, from
	  0 -> 1.
	* Calls `Bfs.shortest_path` to extract the
	  shortest path from node 0 to node 1.
	* Checks the result. 
		* If the path ends at
		  node 1, then it returns the path.
		* Otherwise, it raises the `Incorrect`
		  exception.
In general, test cases will follow this workflow.
	1. Construct a graph by creating an empty map
	   for the edges, and updating with `Map.add`
	   to fill them in. The vertices are a
	   `List` of all source and destination
	   vertices incident to an edge.
	2. Call `Bfs.shortest_path`, and check the
	   result against the expected outcome.
	3. Update `main.ml` to call the relevant test
	   case from `bfs.mlw`, and print the result.

Note that Why3 does not have facilities to print output
to standard out, so you cannot directly print intermediate
results. However, you can return intermediate results
from your test case to be printed by `main.ml`, if you
find it necessary to do so when debugging.

## Linux (including VirtualBox and WSL) & macOS

If you have installed Why3 locally on Linux or macOS,
then the first thing that you must do is to install
`ocamlbuild`. This is accomplished by running the following
command:

``
opam install ocamlbuild
``

Installing `ocamlbuild` is only necessary once.
When this succeeds, you can then compile your code
by running:

``
make main
``

This will execute the following commands to produce 
the executable `main.native`:

``
why3 extract -D ocaml64 --recursive bfs.mlw -o bfs.ml
ocamlbuild -r -pkg zarith main.native
``

As long as your Why3 code does not have any errors,
you can then run the executable compiled by `ocamlbuild`:

``
./main.native
``

## Docker

If you have used the docker image to run Why3, then
start by pulling the most up-to-date image:

``
docker pull mfredrik/15414:why3-s22
``

Re-tag this image as the shorter name `why3`:

``
docker tag mfredrik/15414:why3-s22 why3
``

To compile and test your code, you should start the
container in interactive mode. The following command
will start the container with `/data` mapped to your
Assignment 7 directory, running the `bash` shell so that
you can enter commands as though you were running Linux
locally:

``
docker run --rm -it --entrypoint /bin/bash --volume <your assignment 7 directory>:/data --workdir /data why3
``

Each time you run this command, you need to initialize
the `bash` environment so that `why3` and `ocamlbuild`
are in the path:

``
eval $(opam env)
``

You can now use `why3` from the command line normally,
and compile your code in the same way that Linux/WSL/macOS
users do. 

``
make main
``

This will execute the following commands will produce an
executable named `main.native`:

``
why3 extract -D ocaml64 --recursive bfs.mlw -o bfs.ml
ocamlbuild -r -pkg zarith main.native
``

You can run this by executing:

``
./main.native
``