import argparse
from z3 import *
from typing import List, Optional

def recover_previous(observed: List[int], modulo: int) -> Optional[int]:

	# The obs_vals represent the observed pseudorandom values
	obs_vals = [BitVecVal(obs, 32) for obs in observed]
	
	# The state_vars represent the hidden internal states of the LCG generator
	state_vars = [BitVec('rseed_{}'.format(i), 32) for i in range(len(observed)+1)]

	# prev_output 
	prev_output = BitVec('previous', 32)

	s = Solver()

	'''
		TODO: Add constraints to `s` that:
		1. Relate state_vars[i] and state_vars[i+1] to each other
		   according to the recurrence implemented in `rand`
		2. Relate the observed values in `obs_vals` to the
		   corresponding `state_var` that generated it.
		3. Relate `prev_output` to the earliest internal state
	'''

	if s.check() == sat:
		prev_sol = s.model().evaluate(prev_output, model_completion=True).as_signed_long()
		
		'''
			TODO: Determine whether `prev_sol` is the unique solution
			1. If it is, then return it
			2. If it is not, then return `None`
		'''
	else:
		prev_sol = None

	return prev_sol

if __name__ == '__main__':

	parser = argparse.ArgumentParser(description='Assignment 6, Problem 2 Task 3')
	parser.add_argument('obs', type=int, nargs='+', help='prng observations')
	parser.add_argument('modulo', type=int, help='modular reduction base')
	
	args = parser.parse_args()

	print(recover_previous(args.obs, args.modulo))