(*
 * This is the ocaml code to be linked with the ocaml code
 * extracted from your Why3 implementation in bfs.mlw
 *
 * Under Linux or Mac, you can build and execute a binary
 * with the following commands:

   why3 extract -D ocaml64 --recursive bfs.mlw -o bfs.ml
   ocamlbuild -r -pkg zarith main.native 
   ./main.native

 * The functions Bfs.test<i> should raise the exception
 * Bfs.Incorrect in case the actual outcome differs from the
 * expected outcome.  This means main.native will exit with
 * an error code.
 *)

let rec print_path (vs : Bfs.vertex list) =
match vs with
| [] -> "."
| v::[] -> Z.to_string v ^ "."
| v::vs -> Z.to_string v ^ "," ^ print_path vs

let print_outcome (r : Bfs.outcome) =
match r with
| Bfs.NoPath -> "NoPath"
| Bfs.SomePath vs -> "SomePath " ^ print_path vs
| Bfs.Error -> "Error"

let () = print_endline (print_outcome (Bfs.test0 ()))
(*
let () = print_endline (print_outcome (Bfs.test1 ()))
let () = print_endline (print_outcome (Bfs.test2 ()))
let () = print_endline (print_outcome (Bfs.test3 ()))
let () = print_endline (print_outcome (Bfs.test4 ()))
let () = print_endline (print_outcome (Bfs.test5 ()))
*)
